/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor.ActionExpressionVisitor;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor.ConditionExpressionVisitor;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRule;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleCondition;
import com.liferay.dynamic.data.mapping.spi.converter.serializer.SPIDDMFormRuleSerializerContext;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SPIDDMFormRuleConverter.class})
public class DDMFormRuleConverterImpl
implements SPIDDMFormRuleConverter {
    @Reference
    protected DDMExpressionFactory ddmExpressionFactory;
    private static final String _COMPARISON_EXPRESSION_FORMAT = "%s %s %s";
    private static final String _FUNCTION_CALL_BINARY_EXPRESSION_FORMAT = "%s(%s, %s)";
    private static final String _FUNCTION_CALL_UNARY_EXPRESSION_FORMAT = "%s(%s)";
    private static final String _NOT_EXPRESSION_FORMAT = "not(%s)";
    private static final Map<String, String> _operatorFunctionNames = HashMapBuilder.put((Object)"belongs-to", (Object)"belongsTo").put((Object)"contains", (Object)"contains").put((Object)"equals-to", (Object)"equals").put((Object)"is-empty", (Object)"isEmpty").put((Object)"not-contains", (Object)"contains").put((Object)"not-equals-to", (Object)"equals").put((Object)"not-is-empty", (Object)"isEmpty").build();
    private static final Map<String, String> _operators = HashMapBuilder.put((Object)"greater-than", (Object)">").put((Object)"greater-than-equals", (Object)">=").put((Object)"less-than", (Object)"<").put((Object)"less-than-equals", (Object)"<=").build();

    public List<SPIDDMFormRule> convert(List<DDMFormRule> ddmFormRules) {
        return TransformUtil.transform(ddmFormRules, this::_convertRule);
    }

    public List<DDMFormRule> convert(List<SPIDDMFormRule> spiDDMFormRules, SPIDDMFormRuleSerializerContext spiDDMFormRuleSerializerContext) {
        return TransformUtil.transform(spiDDMFormRules, formRule -> this._convertRule((SPIDDMFormRule)formRule, spiDDMFormRuleSerializerContext));
    }

    protected void setSPIDDMFormRuleActions(SPIDDMFormRule spiDDMFormRule, List<String> actions) {
        spiDDMFormRule.setSPIDDMFormRuleActions(TransformUtil.transform(actions, this::_convertAction));
    }

    protected void setSPIDDMFormRuleConditions(SPIDDMFormRule spiDDMFormRule, String conditionExpressionString) {
        Expression conditionExpression = this._createExpression(conditionExpressionString);
        ConditionExpressionVisitor conditionExpressionVisitor = new ConditionExpressionVisitor();
        conditionExpression.accept((ExpressionVisitor)conditionExpressionVisitor);
        spiDDMFormRule.setSPIDDMFormRuleConditions(conditionExpressionVisitor.getSPIDDMFormRuleConditions());
        spiDDMFormRule.setLogicalOperator(conditionExpressionVisitor.getLogicalOperator());
    }

    private SPIDDMFormRuleAction _convertAction(String actionExpressionString) {
        Expression actionExpression = this._createExpression(actionExpressionString);
        return (SPIDDMFormRuleAction)actionExpression.accept((ExpressionVisitor)new ActionExpressionVisitor());
    }

    private String _convertCondition(SPIDDMFormRuleCondition spiDDMFormRuleCondition) {
        String operator = spiDDMFormRuleCondition.getOperator();
        List operands = spiDDMFormRuleCondition.getOperands();
        if (_operators.containsKey(operator)) {
            if (operands.size() < 2) {
                return "";
            }
            return String.format(_COMPARISON_EXPRESSION_FORMAT, this._convertOperand((SPIDDMFormRuleCondition.Operand)operands.get(0)), _operators.get(operator), this._convertOperand((SPIDDMFormRuleCondition.Operand)operands.get(1)));
        }
        String functionName = _operatorFunctionNames.getOrDefault(operator, operator);
        String condition = this._createCondition(functionName, operands);
        if (operator.startsWith("not")) {
            return String.format(_NOT_EXPRESSION_FORMAT, condition);
        }
        return condition;
    }

    private String _convertConditions(String logicalOperator, List<SPIDDMFormRuleCondition> spiDDMFormRuleConditions) {
        if (spiDDMFormRuleConditions.size() == 1) {
            return this._convertCondition(spiDDMFormRuleConditions.get(0));
        }
        StringBundler sb = new StringBundler(spiDDMFormRuleConditions.size() * 4);
        for (SPIDDMFormRuleCondition spiDDMFormRuleCondition : spiDDMFormRuleConditions) {
            sb.append(this._convertCondition(spiDDMFormRuleCondition));
            sb.append(" ");
            sb.append(logicalOperator);
            sb.append(" ");
        }
        sb.setIndex(sb.index() - 3);
        return sb.toString();
    }

    private String _convertOperand(SPIDDMFormRuleCondition.Operand operand) {
        if (Objects.equals(operand.getType(), "field")) {
            return String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, "getValue", StringUtil.quote((String)operand.getValue()));
        }
        if (Objects.equals(operand.getType(), "json")) {
            return String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, "getJSONValue", StringUtil.quote((String)operand.getValue()));
        }
        String value = operand.getValue();
        if (this._isNumericConstant(operand.getType())) {
            return value;
        }
        if (Objects.equals(operand.getType(), "string")) {
            return StringUtil.quote((String)value);
        }
        String operandType = operand.getType();
        String string = StringUtil.merge((Collection)TransformUtil.transformToList((Object[])StringUtil.split((String)value), curVal -> StringUtil.quote((String)StringUtil.trim((String)curVal))), (String)", ");
        if (!operandType.equals("list")) {
            return string;
        }
        return StringBundler.concat((String[])new String[]{"[", string, "]"});
    }

    private String _convertOperands(List<SPIDDMFormRuleCondition.Operand> operands) {
        StringBundler sb = new StringBundler(operands.size());
        boolean hasNestedFunction = this._hasNestedFunction(operands);
        for (int i = 0; i < operands.size(); ++i) {
            SPIDDMFormRuleCondition.Operand operand = operands.get(i);
            if (hasNestedFunction) {
                sb.append(operand.getValue());
            } else if (i > 0 && Objects.equals(operand.getType(), "option")) {
                SPIDDMFormRuleCondition.Operand previousOperand = operands.get(i - 1);
                sb.append(String.format(_FUNCTION_CALL_BINARY_EXPRESSION_FORMAT, "getOptionLabel", StringUtil.quote((String)previousOperand.getValue()), StringUtil.quote((String)operand.getValue())));
            } else {
                sb.append(this._convertOperand(operand));
            }
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private SPIDDMFormRule _convertRule(DDMFormRule ddmFormRule) {
        SPIDDMFormRule spiDDMFormRule = new SPIDDMFormRule();
        spiDDMFormRule.setName(ddmFormRule.getName());
        this.setSPIDDMFormRuleConditions(spiDDMFormRule, ddmFormRule.getCondition());
        this.setSPIDDMFormRuleActions(spiDDMFormRule, ddmFormRule.getActions());
        return spiDDMFormRule;
    }

    private DDMFormRule _convertRule(SPIDDMFormRule spiDDMFormRule, SPIDDMFormRuleSerializerContext spiDDMFormRuleSerializerContext) {
        return new DDMFormRule(TransformUtil.transform((Collection)spiDDMFormRule.getSPIDDMFormRuleActions(), spiDDMFormRuleAction -> spiDDMFormRuleAction.serialize(spiDDMFormRuleSerializerContext)), this._convertConditions(spiDDMFormRule.getLogicalOperator(), spiDDMFormRule.getSPIDDMFormRuleConditions()), spiDDMFormRule.getName());
    }

    private String _createCondition(String functionName, List<SPIDDMFormRuleCondition.Operand> operands) {
        if (Objects.equals(functionName, "belongsTo")) {
            operands.removeIf(operand -> StringUtil.equals((String)operand.getType(), (String)"user"));
        }
        return String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, functionName, this._convertOperands(operands));
    }

    private Expression _createExpression(String expressionString) {
        try {
            CreateExpressionRequest createExpressionRequest = CreateExpressionRequest.Builder.newBuilder((String)expressionString).build();
            DDMExpression ddmExpression = this.ddmExpressionFactory.createExpression(createExpressionRequest);
            return ddmExpression.getModel();
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new IllegalStateException(String.format("Unable to parse expression \"%s\"", expressionString), ddmExpressionException);
        }
    }

    private boolean _hasNestedFunction(List<SPIDDMFormRuleCondition.Operand> operands) {
        for (SPIDDMFormRuleCondition.Operand operand : operands) {
            if (!this._isNestedFunction(operand.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean _isNestedFunction(String operandValue) {
        return operandValue.matches("[aA-zZ0-9]+[(].*[aA-zZ0-9]+[(].*[)].*[)]");
    }

    private boolean _isNumericConstant(String operandType) {
        return operandType.equals("integer") || operandType.equals("double");
    }
}

