/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.dynamic.data.mapping.form.builder.internal.servlet.BaseDDMFormBuilderServlet;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.dynamic.data.mapping.util.comparator.DataProviderInstanceNameComparator;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dynamic.data.mapping.form.builder.servlet=true", "osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-data-provider-instances", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMDataProviderInstancesServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-data-provider-instances/*"}, service={Servlet.class})
public class DDMDataProviderInstancesServlet
extends BaseDDMFormBuilderServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    private DDMDataProviderInstanceService _ddmDataProviderInstanceService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        JSONArray dataProviderInstancesJSONArray = this._getDataProviderInstancesJSONArray(httpServletRequest);
        if (dataProviderInstancesJSONArray == null) {
            httpServletResponse.sendError(400);
            return;
        }
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)dataProviderInstancesJSONArray.toString());
    }

    private JSONArray _getDataProviderInstancesJSONArray(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String languageId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"languageId", (String)themeDisplay.getLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        long scopeGroupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"scopeGroupId", (long)themeDisplay.getScopeGroupId());
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (scopeGroup.isStagingGroup()) {
            scopeGroupId = scopeGroup.getLiveGroupId();
        }
        int start = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"start", (int)-1);
        int end = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"end", (int)-1);
        DataProviderInstanceNameComparator dataProviderInstanceNameComparator = new DataProviderInstanceNameComparator(true);
        List ddmDataProviderInstances = ListUtil.concat((List[])new List[]{this._ddmDataProviderInstanceService.search(themeDisplay.getCompanyId(), new long[]{scopeGroupId}, null, start, end, (OrderByComparator)dataProviderInstanceNameComparator), this._ddmDataProviderInstanceService.search(themeDisplay.getCompanyId(), this._portal.getAncestorSiteGroupIds(scopeGroupId), null, start, end, (OrderByComparator)dataProviderInstanceNameComparator)});
        JSONArray dataProviderInstancesJSONArray = this._jsonFactory.createJSONArray();
        for (DDMDataProviderInstance ddmDataProviderInstance : ddmDataProviderInstances) {
            JSONObject dataProviderInstanceJSONObject = this._jsonFactory.createJSONObject();
            dataProviderInstanceJSONObject.put("id", ddmDataProviderInstance.getDataProviderInstanceId()).put("name", ddmDataProviderInstance.getName(locale)).put("uuid", ddmDataProviderInstance.getUuid());
            dataProviderInstancesJSONArray.put(dataProviderInstanceJSONObject);
        }
        return dataProviderInstancesJSONArray;
    }
}

