/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.configuration;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;

import java.util.Map;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

/**
 * @author Renato Rego
 */
@Component(
	configurationPid = "com.liferay.dynamic.data.mapping.form.builder.internal.configuration.FFDDMFormSidebarConfiguration",
	service = FFDDMFormSidebarConfigurationActivator.class
)
public class FFDDMFormSidebarConfigurationActivator {

	@Activate
	@Modified
	protected void activate(Map<String, Object> properties) {
		_ffDDMFormSidebarConfiguration = ConfigurableUtil.createConfigurable(
			FFDDMFormSidebarConfiguration.class, properties);
	}

	private volatile FFDDMFormSidebarConfiguration
		_ffDDMFormSidebarConfiguration;

}