/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.settings;

import com.liferay.dynamic.data.mapping.form.builder.internal.helper.DDMExpressionFunctionMetadataHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.spi.form.builder.settings.DDMFormBuilderSettingsRetrieverHelper;
import com.liferay.dynamic.data.mapping.util.comparator.StructureNameComparator;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormBuilderSettingsRetrieverHelper.class})
public class DDMFormBuilderSettingsRetrieverHelperImpl
implements DDMFormBuilderSettingsRetrieverHelper {
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMDataProviderInstanceParameterSettingsServlet)")
    private Servlet _ddmDataProviderInstanceParameterSettingsServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMDataProviderInstancesServlet)")
    private Servlet _ddmDataProviderInstancesServlet;
    @Reference
    private DDMExpressionFunctionMetadataHelper _ddmExpressionFunctionMetadataHelper;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFieldSetDefinitionServlet)")
    private Servlet _ddmFieldSetDefinitionServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFieldSettingsDDMFormContextServlet)")
    private Servlet _ddmFieldSettingsDDMFormContextServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.DDMFormContextProviderServlet)")
    private Servlet _ddmFormContextProviderServlet;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMFormFunctionsServlet)")
    private Servlet _ddmFormFunctionsServlet;
    @Reference
    private DDMStructureService _ddmStructureService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.RolesServlet)")
    private Servlet _rolesServlet;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    public String getDDMDataProviderInstanceParameterSettingsURL() {
        String servletContextPath = this._getServletContextPath(this._ddmDataProviderInstanceParameterSettingsServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-provider-instance-parameter-settings/");
    }

    public String getDDMDataProviderInstancesURL() {
        String servletContextPath = this._getServletContextPath(this._ddmDataProviderInstancesServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-data-provider-instances/");
    }

    public String getDDMFieldSetDefinitionURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFieldSetDefinitionServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-fieldset-definition/");
    }

    public String getDDMFieldSettingsDDMFormContextURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFieldSettingsDDMFormContextServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-field-settings-form-context/");
    }

    public String getDDMFormContextProviderURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFormContextProviderServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-context-provider/");
    }

    public String getDDMFunctionsURL() {
        String servletContextPath = this._getServletContextPath(this._ddmFormFunctionsServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-functions/");
    }

    public JSONArray getFieldSetsMetadataJSONArray(long companyId, long scopeGroupId, long fieldSetClassNameId, Locale locale) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        if (fieldSetClassNameId == 0L) {
            return jsonArray;
        }
        List ddmStructures = this._ddmStructureService.search(companyId, new long[]{scopeGroupId}, fieldSetClassNameId, "", 2, -1, -1, -1, (OrderByComparator)new StructureNameComparator(true));
        for (DDMStructure ddmStructure : ddmStructures) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            jsonObject.put("description", ddmStructure.getDescription(locale, true)).put("icon", "forms").put("id", ddmStructure.getStructureId()).put("name", ddmStructure.getName(locale, true));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public String getRolesURL() {
        String servletContextPath = this._getServletContextPath(this._rolesServlet);
        return servletContextPath.concat("/dynamic-data-mapping-form-builder-roles/");
    }

    public String getSerializedDDMExpressionFunctionsMetadata(Locale locale) {
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        return jsonSerializer.serializeDeep(this._ddmExpressionFunctionMetadataHelper.getDDMExpressionFunctionsMetadata(locale));
    }

    public String getSerializedDDMFormRules(DDMForm ddmForm) {
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        return jsonSerializer.serializeDeep((Object)this._spiDDMFormRuleConverter.convert(ddmForm.getDDMFormRules()));
    }

    private String _getServletContextPath(Servlet servlet) {
        String proxyPath = this._portal.getPathProxy();
        ServletConfig servletConfig = servlet.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        return proxyPath.concat(servletContext.getContextPath());
    }
}

