/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInputParametersSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderOutputParametersSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderParameterSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderTracker;
import com.liferay.dynamic.data.mapping.form.builder.internal.servlet.BaseDDMFormBuilderServlet;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormInstanceFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-provider-instance-parameter-settings", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.DDMDataProviderInstanceParameterSettingsServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-provider-instance-parameter-settings/*"}, service={Servlet.class})
public class DDMDataProviderInstanceParameterSettingsServlet
extends BaseDDMFormBuilderServlet {
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderInstanceParameterSettingsServlet.class);
    private static final long serialVersionUID = 1L;
    @Reference
    private DDMDataProviderInstanceService _ddmDataProviderInstanceService;
    @Reference
    private DDMDataProviderTracker _ddmDataProviderTracker;
    @Reference(target="(ddm.form.values.deserializer.type=json)")
    private DDMFormValuesDeserializer _jsonDDMFormValuesDeserializer;
    @Reference
    private JSONFactory _jsonFactory;

    protected JSONObject createParametersJSONObject(DDMDataProvider ddmDataProvider, DDMFormValues ddmFormValues) throws Exception {
        JSONObject parametersJSONObject = this._jsonFactory.createJSONObject();
        if (!ClassUtil.isSubclass((Class)ddmDataProvider.getSettings(), DDMDataProviderParameterSettings.class)) {
            return parametersJSONObject;
        }
        DDMDataProviderParameterSettings ddmDataProviderParameterSetting = (DDMDataProviderParameterSettings)DDMFormInstanceFactory.create((Class)ddmDataProvider.getSettings(), (DDMFormValues)ddmFormValues);
        parametersJSONObject.put("inputs", this._getInputParametersJSONArray(ddmDataProviderParameterSetting.inputParameters())).put("outputs", this._getOutputParametersJSONArray(ddmDataProviderParameterSetting.outputParameters()));
        return parametersJSONObject;
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._jsonDDMFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        JSONObject parametersJSONObject = this._getParameterSettingsJSONObject(httpServletRequest);
        if (parametersJSONObject == null) {
            httpServletResponse.sendError(400);
            return;
        }
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)parametersJSONObject.toJSONString());
    }

    protected DDMFormValues getDataProviderFormValues(DDMDataProvider ddmDataProvider, DDMDataProviderInstance ddmDataProviderInstance) {
        DDMForm ddmForm = DDMFormFactory.create((Class)ddmDataProvider.getSettings());
        return this.deserialize(ddmDataProviderInstance.getDefinition(), ddmForm);
    }

    private DDMDataProviderInstance _getDDMDataProviderInstance(HttpServletRequest httpServletRequest) throws PortalException {
        long ddmDataProviderInstanceId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"ddmDataProviderInstanceId");
        return this._ddmDataProviderInstanceService.getDataProviderInstance(ddmDataProviderInstanceId);
    }

    private JSONArray _getInputParametersJSONArray(DDMDataProviderInputParametersSettings[] ddmDataProviderInputParametersSettings) throws Exception {
        JSONArray inputsJSONArray = this._jsonFactory.createJSONArray();
        for (DDMDataProviderInputParametersSettings ddmDataProviderInputParameterSetting : ddmDataProviderInputParametersSettings) {
            String name = ddmDataProviderInputParameterSetting.inputParameterName();
            String type = this._getType(ddmDataProviderInputParameterSetting.inputParameterType());
            if (Validator.isNull((String)name) || Validator.isNull((String)type)) continue;
            inputsJSONArray.put(() -> {
                JSONObject inputJSONObject = this._jsonFactory.createJSONObject();
                return inputJSONObject.put("id", name).put("label", () -> {
                    String label = ddmDataProviderInputParameterSetting.inputParameterLabel();
                    if (Validator.isNotNull((String)label)) {
                        return label;
                    }
                    return name;
                }).put("name", name).put("required", ddmDataProviderInputParameterSetting.inputParameterRequired()).put("type", type);
            });
        }
        return inputsJSONArray;
    }

    private JSONArray _getOutputParametersJSONArray(DDMDataProviderOutputParametersSettings[] ddmDataProviderOutputParametersSettings) throws Exception {
        JSONArray outputsJSONArray = this._jsonFactory.createJSONArray();
        for (DDMDataProviderOutputParametersSettings ddmDataProviderOutputParameterSetting : ddmDataProviderOutputParametersSettings) {
            String path = ddmDataProviderOutputParameterSetting.outputParameterPath();
            String type = this._getType(ddmDataProviderOutputParameterSetting.outputParameterType());
            if (Validator.isNull((String)path) || Validator.isNull((String)type)) continue;
            outputsJSONArray.put(() -> {
                JSONObject outputJSONObject = this._jsonFactory.createJSONObject();
                return outputJSONObject.put("id", ddmDataProviderOutputParameterSetting.outputParameterId()).put("name", () -> {
                    String name = ddmDataProviderOutputParameterSetting.outputParameterName();
                    if (Validator.isNotNull((String)name)) {
                        return name;
                    }
                    return path;
                }).put("type", type);
            });
        }
        return outputsJSONArray;
    }

    private JSONObject _getParameterSettingsJSONObject(HttpServletRequest httpServletRequest) {
        try {
            DDMDataProviderInstance ddmDataProviderInstance = this._getDDMDataProviderInstance(httpServletRequest);
            DDMDataProvider ddmDataProvider = this._ddmDataProviderTracker.getDDMDataProvider(ddmDataProviderInstance.getType());
            DDMFormValues ddmFormValues = this.getDataProviderFormValues(ddmDataProvider, ddmDataProviderInstance);
            return this.createParametersJSONObject(ddmDataProvider, ddmFormValues);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private String _getType(String type) {
        try {
            JSONArray typeJSONArray = this._jsonFactory.createJSONArray(type);
            return typeJSONArray.getString(0);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return type;
        }
    }
}

