/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.converter;

import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor.ActionExpressionVisitor;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleAction;

import java.util.List;

/**
 * @author Leonardo Barros
 */
public class DDMFormRuleActionFactory {

	public static SPIDDMFormRuleAction create(
		String action, List<Expression> expressions,
		ActionExpressionVisitor actionExpressionVisitor) {

		if (action.equals("auto-fill")) {
			return AutoFillDDMFormRuleActionFactory.create(
				expressions, actionExpressionVisitor);
		}
		else if (action.equals("calculate")) {
			return CalculateDDMFormRuleActionFactory.create(
				expressions, actionExpressionVisitor);
		}
		else if (action.equals("jump-to-page")) {
			return JumpToPageDDMFormRuleActionFactory.create(
				expressions, actionExpressionVisitor);
		}

		return DefaultDDMFormRuleActionFactory.create(
			action, expressions, actionExpressionVisitor);
	}

}