/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.helper;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionTracker;
import com.liferay.dynamic.data.mapping.form.builder.internal.util.DDMExpressionFunctionMetadata;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMExpressionFunctionMetadataHelper.class})
public class DDMExpressionFunctionMetadataHelper {
    private static final String _TYPE_BOOLEAN = "boolean";
    private static final String _TYPE_LIST = "list";
    private static final String _TYPE_NUMBER = "number";
    private static final String _TYPE_TEXT = "text";
    private static final String _TYPE_USER = "user";
    private static final Map<String, String> _binaryFunctions = LinkedHashMapBuilder.put((Object)"equals-to", (Object)"is-equal-to").put((Object)"not-equals-to", (Object)"is-not-equal-to").build();
    private static final Map<String, String> _numberBinaryFunctions = LinkedHashMapBuilder.put((Object)"greater-than", (Object)"is-greater-than").put((Object)"greater-than-equals", (Object)"is-greater-than-or-equal-to").put((Object)"less-than", (Object)"is-less-than").put((Object)"less-than-equals", (Object)"is-less-than-or-equal-to").build();
    private static final Map<String, String> _textBinaryFunctions = LinkedHashMapBuilder.put((Object)"contains", (Object)"contains").put((Object)"not-contains", (Object)"does-not-contain").build();
    private static final Map<String, String> _unaryFunctions = LinkedHashMapBuilder.put((Object)"is-empty", (Object)"is-empty").put((Object)"not-is-empty", (Object)"is-not-empty").build();
    @Reference
    private DDMExpressionFunctionTracker _ddmExpressionFunctionTracker;
    @Reference
    private Portal _portal;

    public Map<String, List<DDMExpressionFunctionMetadata>> getDDMExpressionFunctionsMetadata(Locale locale) {
        HashMap<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap = new HashMap<String, List<DDMExpressionFunctionMetadata>>();
        this.populateCustomDDMExpressionFunctionsMetadata(ddmExpressionFunctionMetadatasMap, locale);
        this.populateDDMExpressionFunctionsMetadata(ddmExpressionFunctionMetadatasMap, this.getResourceBundle(locale));
        return ddmExpressionFunctionMetadatasMap;
    }

    protected void addDDMExpressionFunctionMetadata(Map<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap, DDMExpressionFunctionMetadata ddmExpressionFunctionMetadata) {
        String firstParameterClassName = ddmExpressionFunctionMetadata.getParameterClassNames()[0];
        List<DDMExpressionFunctionMetadata> ddmExpressionFunctionMetadatas = ddmExpressionFunctionMetadatasMap.get(firstParameterClassName);
        if (ddmExpressionFunctionMetadatas == null) {
            ddmExpressionFunctionMetadatas = new ArrayList<DDMExpressionFunctionMetadata>();
            ddmExpressionFunctionMetadatasMap.put(firstParameterClassName, ddmExpressionFunctionMetadatas);
        }
        ddmExpressionFunctionMetadatas.add(ddmExpressionFunctionMetadata);
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle portalResourceBundle = this._portal.getResourceBundle(locale);
        ResourceBundle portletResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return new AggregateResourceBundle(new ResourceBundle[]{portletResourceBundle, portalResourceBundle});
    }

    protected void populateCustomDDMExpressionFunctionsMetadata(Map<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap, Locale locale) {
        Map customDDMExpressionFunctions = this._ddmExpressionFunctionTracker.getCustomDDMExpressionFunctions();
        for (Map.Entry entry : customDDMExpressionFunctions.entrySet()) {
            Method method2;
            int parameterCount;
            DDMExpressionFunction ddmExpressionFunction = (DDMExpressionFunction)entry.getValue();
            Class<?> clazz = ddmExpressionFunction.getClass();
            Stream<Method> stream = Arrays.stream(clazz.getMethods());
            Optional<Method> optional = stream.filter(method -> Objects.equals(method.getName(), "apply") && Objects.equals(method.getReturnType(), Boolean.class)).findFirst();
            if (!optional.isPresent() || (parameterCount = (method2 = optional.get()).getParameterCount()) > 2) continue;
            String label = ddmExpressionFunction.getLabel(locale);
            if (Validator.isNull((String)label)) {
                label = (String)entry.getKey();
            }
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata((String)entry.getKey(), label, _TYPE_BOOLEAN, this._getParameterClassNames(parameterCount, _TYPE_NUMBER)));
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata((String)entry.getKey(), label, _TYPE_BOOLEAN, this._getParameterClassNames(parameterCount, _TYPE_TEXT)));
        }
    }

    protected void populateDDMExpressionFunctionsMetadata(Map<String, List<DDMExpressionFunctionMetadata>> ddmExpressionFunctionMetadatasMap, ResourceBundle resourceBundle) {
        this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata("belongs-to", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"belongs-to"), _TYPE_BOOLEAN, new String[]{_TYPE_USER, _TYPE_LIST}));
        this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata("equals-to", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"is-equal-to"), _TYPE_BOOLEAN, new String[]{_TYPE_BOOLEAN, _TYPE_BOOLEAN}));
        for (Map.Entry<String, String> entry : _binaryFunctions.entrySet()) {
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_NUMBER, _TYPE_NUMBER}));
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_TEXT, _TYPE_TEXT}));
        }
        for (Map.Entry<String, String> entry : _numberBinaryFunctions.entrySet()) {
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_NUMBER, _TYPE_NUMBER}));
        }
        for (Map.Entry<String, String> entry : _textBinaryFunctions.entrySet()) {
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_TEXT, _TYPE_TEXT}));
        }
        for (Map.Entry<String, String> entry : _unaryFunctions.entrySet()) {
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_NUMBER}));
            this.addDDMExpressionFunctionMetadata(ddmExpressionFunctionMetadatasMap, new DDMExpressionFunctionMetadata(entry.getKey(), LanguageUtil.get((ResourceBundle)resourceBundle, (String)entry.getValue()), _TYPE_BOOLEAN, new String[]{_TYPE_TEXT}));
        }
    }

    private String[] _getParameterClassNames(int parameterCount, String parameterClassName) {
        Object[] parameterClassNames = new String[parameterCount];
        Arrays.fill(parameterClassNames, parameterClassName);
        return parameterClassNames;
    }
}

