/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.util;

import com.liferay.petra.lang.HashUtil;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author Rafael Praxedes
 */
public class DDMExpressionFunctionMetadata {

	public DDMExpressionFunctionMetadata(
		String name, String label, String returnClassName,
		String[] parameterClassNames) {

		_name = name;
		_label = label;
		_returnClassName = returnClassName;
		_parameterClassNames = parameterClassNames;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DDMExpressionFunctionMetadata)) {
			return false;
		}

		DDMExpressionFunctionMetadata ddmExpressionFunctionMetadata =
			(DDMExpressionFunctionMetadata)object;

		if (Objects.equals(_label, ddmExpressionFunctionMetadata._label) &&
			Objects.equals(_name, ddmExpressionFunctionMetadata._name) &&
			Arrays.equals(
				_parameterClassNames,
				ddmExpressionFunctionMetadata._parameterClassNames) &&
			Objects.equals(
				_returnClassName,
				ddmExpressionFunctionMetadata._returnClassName)) {

			return true;
		}

		return false;
	}

	public String getLabel() {
		return _label;
	}

	public String getName() {
		return _name;
	}

	public String[] getParameterClassNames() {
		return _parameterClassNames;
	}

	public String getReturnClassName() {
		return _returnClassName;
	}

	@Override
	public int hashCode() {
		int hash = HashUtil.hash(0, _label);

		hash = HashUtil.hash(hash, _name);

		for (String parameterClassName : _parameterClassNames) {
			hash = HashUtil.hash(hash, parameterClassName);
		}

		return HashUtil.hash(hash, _returnClassName);
	}

	private final String _label;
	private final String _name;
	private final String[] _parameterClassNames;
	private final String _returnClassName;

}