/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action;

import com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer.AutoFillDDMFormRuleActionSerializer;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.spi.converter.serializer.SPIDDMFormRuleActionSerializer;
import com.liferay.dynamic.data.mapping.spi.converter.serializer.SPIDDMFormRuleSerializerContext;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSON;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author Rafael Praxedes
 */
public class AutoFillDDMFormRuleAction implements SPIDDMFormRuleAction {

	public AutoFillDDMFormRuleAction() {
	}

	public AutoFillDDMFormRuleAction(
		String ddmDataProviderInstanceUUID, Map<String, String> inputMapper,
		Map<String, String> outputMapper) {

		_ddmDataProviderInstanceUUID = ddmDataProviderInstanceUUID;
		_inputMapper = inputMapper;
		_outputMapper = outputMapper;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof AutoFillDDMFormRuleAction)) {
			return false;
		}

		AutoFillDDMFormRuleAction autoFillDDMFormRuleAction =
			(AutoFillDDMFormRuleAction)object;

		if (Objects.equals(
				_ddmDataProviderInstanceUUID,
				autoFillDDMFormRuleAction._ddmDataProviderInstanceUUID) &&
			Objects.equals(
				_inputMapper, autoFillDDMFormRuleAction._inputMapper) &&
			Objects.equals(
				_outputMapper, autoFillDDMFormRuleAction._outputMapper)) {

			return true;
		}

		return false;
	}

	@Override
	public String getAction() {
		return "auto-fill";
	}

	@JSON(name = "ddmDataProviderInstanceUUID")
	public String getDDMDataProviderInstanceUUID() {
		return _ddmDataProviderInstanceUUID;
	}

	@JSON(name = "inputs")
	public Map<String, String> getInputParametersMapper() {
		return _inputMapper;
	}

	@JSON(name = "outputs")
	public Map<String, String> getOutputParametersMapper() {
		return _outputMapper;
	}

	@Override
	public int hashCode() {
		int hash = HashUtil.hash(0, _ddmDataProviderInstanceUUID);

		hash = HashUtil.hash(hash, _inputMapper);

		return HashUtil.hash(hash, _inputMapper);
	}

	@Override
	public String serialize(
		SPIDDMFormRuleSerializerContext spiDDMFormRuleSerializerContext) {

		SPIDDMFormRuleActionSerializer spiDDMFormRuleActionSerializer =
			new AutoFillDDMFormRuleActionSerializer(this);

		return spiDDMFormRuleActionSerializer.serialize(
			spiDDMFormRuleSerializerContext);
	}

	public void setDDMDataProviderInstanceUUID(
		String ddmDataProviderInstanceUUID) {

		_ddmDataProviderInstanceUUID = ddmDataProviderInstanceUUID;
	}

	public void setInputParametersMapper(Map<String, String> inputMapper) {
		_inputMapper = inputMapper;
	}

	public void setOutputParametersMapper(Map<String, String> outputMapper) {
		_outputMapper = outputMapper;
	}

	private String _ddmDataProviderInstanceUUID;
	private Map<String, String> _inputMapper = new LinkedHashMap<>();
	private Map<String, String> _outputMapper = new LinkedHashMap<>();

}