Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.9/js/components/LayoutProvider/handlers/fieldDuplicatedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/strings.es', '../util/fields.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _strings = require("../../../util/strings.es");

  var _fields = require("../util/fields.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldDuplicated = function handleFieldDuplicated(_ref, state, event) {
    var editingLanguageId = _ref.editingLanguageId,
        fieldNameGenerator = _ref.fieldNameGenerator;
    var _event$indexes = event.indexes,
        columnIndex = _event$indexes.columnIndex,
        pageIndex = _event$indexes.pageIndex,
        rowIndex = _event$indexes.rowIndex;
    var pages = state.pages;

    var field = _dynamicDataMappingFormRenderer.FormSupport.getField(pages, pageIndex, rowIndex, columnIndex);

    var localizedLabel = (0, _fields.getFieldLocalizedValue)(field.settingsContext.pages, 'label', editingLanguageId);
    var label = (0, _strings.sub)(Liferay.Language.get('copy-of-x'), [localizedLabel]);
    var newFieldName = fieldNameGenerator(label);
    var oldFieldName = field.fieldName;
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(field.settingsContext.pages);

    var duplicatedField = _objectSpread({}, field, {
      fieldName: newFieldName,
      label: label,
      name: newFieldName,
      settingsContext: _objectSpread({}, field.settingsContext, {
        pages: visitor.mapFields(function (field) {
          if (field.fieldName === 'name') {
            field = _objectSpread({}, field, {
              value: newFieldName
            });
          } else if (field.fieldName === 'label') {
            field = _objectSpread({}, field, {
              localizedValue: _objectSpread({}, field.localizedValue, _defineProperty({}, editingLanguageId, label)),
              value: label
            });
          } else if (field.fieldName === 'validation') {
            var expression = field.value.expression;

            if (expression && expression.value) {
              field = _objectSpread({}, field, {
                value: _objectSpread({}, field.value, {
                  expression: _objectSpread({}, field.value.expression, {
                    value: expression.value.replace(oldFieldName, newFieldName)
                  })
                })
              });
            }
          }

          return _objectSpread({}, field);
        })
      })
    });

    var newRowIndex = rowIndex + 1;

    var newRow = _dynamicDataMappingFormRenderer.FormSupport.implAddRow(12, [duplicatedField]);

    return {
      focusedField: _objectSpread({}, duplicatedField, {
        columnIndex: columnIndex,
        pageIndex: pageIndex,
        rowIndex: newRowIndex
      }),
      pages: _dynamicDataMappingFormRenderer.FormSupport.addRow(pages, newRowIndex, pageIndex, newRow)
    };
  };

  var _default = handleFieldDuplicated;
  exports["default"] = _default;
  //# sourceMappingURL=fieldDuplicatedHandler.es.js.map
});
//# sourceMappingURL=fieldDuplicatedHandler.es.js.map