Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.9/js/components/FormBuilder/withActionableFields.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'dynamic-data-mapping-form-renderer', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../util/config.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _config = require("../../util/config.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var getFieldIndexes = function getFieldIndexes(pages, fieldName) {
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
    var indexes = {};
    visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
      if (field.fieldName === fieldName) {
        indexes = {
          columnIndex: columnIndex,
          pageIndex: pageIndex,
          rowIndex: rowIndex
        };
      }
    });
    return indexes;
  };

  var getFieldContainer = function getFieldContainer(pages, fieldName) {
    var _getFieldIndexes = getFieldIndexes(pages, fieldName),
        columnIndex = _getFieldIndexes.columnIndex,
        pageIndex = _getFieldIndexes.pageIndex,
        rowIndex = _getFieldIndexes.rowIndex;

    return document.querySelector(['.col-ddm', "[data-ddm-field-column=\"".concat(columnIndex, "\"]"), "[data-ddm-field-page=\"".concat(pageIndex, "\"]"), "[data-ddm-field-row=\"".concat(rowIndex, "\"]"), ' .ddm-field-container'].join(''));
  };

  var Actions =
  /*#__PURE__*/
  function (_Component) {
    _inherits(Actions, _Component);

    function Actions() {
      _classCallCheck(this, Actions);

      return _possibleConstructorReturn(this, _getPrototypeOf(Actions).apply(this, arguments));
    }

    _createClass(Actions, [{
      key: "created",
      value: function created() {
        this.on('fieldNameChanged', this._handleFieldNameChanged);
        this.expanded = false;
      }
    }, {
      key: "render",
      value: function render() {
        var expanded = this.expanded;
        var _this$props = this.props,
            disabled = _this$props.disabled,
            items = _this$props.items,
            label = _this$props.label,
            spritemap = _this$props.spritemap;
        IncrementalDOM.elementOpen("div", null, null, "onMouseDown", this._handleElementClicked.bind(this), "class", "ddm-field-actions-container");
        IncrementalDOM.elementOpen("span", null, null, "class", "actions-label");
        iDOMHelpers.renderArbitrary(label);
        IncrementalDOM.elementClose("span");
        IncrementalDOM.elementVoid(_clayDropdown.ClayActionsDropdown, null, null, "disabled", disabled, "events", {
          expandedChanged: this._handleExpandedChanged.bind(this),
          itemClicked: this._handleItemClicked.bind(this)
        }, "expanded", expanded, "items", items, "spritemap", spritemap, "ref", "dropdown");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "syncExpanded",
      value: function syncExpanded(expanded) {
        var pages = this.props.pages;
        var fieldName = this.state.fieldName;
        var fieldContainer = getFieldContainer(pages, fieldName);

        if (!fieldContainer) {
          return;
        }

        if (expanded) {
          fieldContainer.classList.add('expanded');
        } else {
          fieldContainer.classList.remove('expanded');
        }
      }
    }, {
      key: "_handleElementClicked",
      value: function _handleElementClicked(_ref) {
        var target = _ref.target;
        var disabled = this.props.disabled;
        var dropdown = this.refs.dropdown;

        if (!dropdown.element.contains(target)) {
          var dispatch = this.context.dispatch;
          var fieldName = this.state.fieldName;
          var pages = this.props.pages;
          var indexes = getFieldIndexes(pages, fieldName);
          dispatch('fieldClicked', indexes);
        } else if (!this.expanded && !disabled) {
          this.expanded = true;
        }
      }
    }, {
      key: "_handleExpandedChanged",
      value: function _handleExpandedChanged(_ref2) {
        var newVal = _ref2.newVal;
        this.expanded = newVal;
        this.syncExpanded(newVal);
      }
    }, {
      key: "_handleFieldNameChanged",
      value: function _handleFieldNameChanged(_ref3) {
        var newVal = _ref3.newVal,
            prevVal = _ref3.prevVal;
        var pages = this.props.pages;
        var expanded = this.state.expanded;
        var newFieldContainer = getFieldContainer(pages, newVal);
        var prevFieldContainer = getFieldContainer(pages, prevVal);

        if (prevFieldContainer && newFieldContainer !== prevFieldContainer) {
          prevFieldContainer.classList.remove('expanded');

          if (expanded && newFieldContainer) {
            newFieldContainer.classList.add('expanded');
          }
        }
      }
    }, {
      key: "_handleItemClicked",
      value: function _handleItemClicked(_ref4) {
        var action = _ref4.data.item.action;
        var fieldName = this.state.fieldName;
        var pages = this.props.pages;
        var indexes = getFieldIndexes(pages, fieldName);
        action(indexes);
        this.refs.dropdown.expanded = false;
      }
    }]);

    return Actions;
  }(_metalJsx["default"]);

  Actions.PROPS = {
    /**
     * @default false
     * @instance
     * @memberof Actions
     * @type {!boolean}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * @default undefined
     * @instance
     * @memberof Actions
     * @type {!string}
     */
    label: _metalState.Config.string(),

    /**
     * @default []
     * @instance
     * @memberof Actions
     * @type {?array<object>}
     */
    pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

    /**
     * @default undefined
     * @instance
     * @memberof Actions
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };
  Actions.STATE = {
    /**
     * @default {}
     * @instance
     * @memberof Actions
     * @type {!Object}
     */
    fieldName: _metalState.Config.string()
  };

  var withActionableFields = function withActionableFields(ChildComponent) {
    var ActionableFields =
    /*#__PURE__*/
    function (_Component2) {
      _inherits(ActionableFields, _Component2);

      function ActionableFields() {
        _classCallCheck(this, ActionableFields);

        return _possibleConstructorReturn(this, _getPrototypeOf(ActionableFields).apply(this, arguments));
      }

      _createClass(ActionableFields, [{
        key: "attached",
        value: function attached() {
          this._eventHandler = new _metalEvents.EventHandler();

          this._eventHandler.add(this.delegate('mouseenter', '.ddm-field-container', this._handleMouseEnterField.bind(this)));
        }
      }, {
        key: "disposeInternal",
        value: function disposeInternal() {
          _get(_getPrototypeOf(ActionableFields.prototype), "disposeInternal", this).call(this);

          this._eventHandler.removeAllListeners();
        }
      }, {
        key: "isActionsEnabled",
        value: function isActionsEnabled() {
          var _this$props2 = this.props,
              defaultLanguageId = _this$props2.defaultLanguageId,
              editingLanguageId = _this$props2.editingLanguageId;
          return defaultLanguageId === editingLanguageId;
        }
      }, {
        key: "render",
        value: function render() {
          var _this$props3 = this.props,
              fieldActions = _this$props3.fieldActions,
              pages = _this$props3.pages,
              spritemap = _this$props3.spritemap;
          IncrementalDOM.elementOpen("div");
          IncrementalDOM.elementOpenStart(ChildComponent);
          iDOMHelpers.forOwn(this.props, iDOMHelpers.attr);
          IncrementalDOM.elementOpenEnd(ChildComponent);
          IncrementalDOM.elementClose(ChildComponent);
          IncrementalDOM.elementVoid(Actions, null, null, "disabled", !this.isActionsEnabled(), "items", fieldActions, "pages", pages, "portalElement", document.body, "spritemap", spritemap, "ref", "selectedFieldActions", "visible", false);
          IncrementalDOM.elementVoid(Actions, null, null, "disabled", !this.isActionsEnabled(), "items", fieldActions, "pages", pages, "portalElement", document.body, "spritemap", spritemap, "ref", "hoveredFieldActions", "visible", false);
          return IncrementalDOM.elementClose("div");
        }
      }, {
        key: "rendered",
        value: function rendered() {
          var focusedField = this.props.focusedField;
          var _this$refs = this.refs,
              hoveredFieldActions = _this$refs.hoveredFieldActions,
              selectedFieldActions = _this$refs.selectedFieldActions;

          if (Object.keys(focusedField).length > 0) {
            var fieldName = focusedField.fieldName;
            this.showActions(selectedFieldActions, fieldName);
          } else {
            selectedFieldActions.props.visible = false;
          }

          if (hoveredFieldActions.state.fieldName) {
            this.showActions(hoveredFieldActions, hoveredFieldActions.state.fieldName);
          }
        }
      }, {
        key: "showActions",
        value: function showActions(actions, fieldName) {
          var _this = this;

          actions.props.label = this._getFieldType(fieldName);
          actions.props.visible = true;

          if (fieldName !== actions.state.fieldName) {
            actions.setState({
              fieldName: fieldName
            });
            actions.refs.dropdown.expanded = false;
          }

          actions.forceUpdate(function () {
            window.requestAnimationFrame(function () {
              var pages = _this.props.pages;
              var fieldContainer = getFieldContainer(pages, fieldName);

              if (fieldContainer) {
                fieldContainer.appendChild(actions.element);
              }
            });
          });
        }
      }, {
        key: "_getColumnField",
        value: function _getColumnField(indexes) {
          var pages = this.props.pages;
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
          var field;
          visitor.mapFields(function (currentField, fieldIndex, columnIndex, rowIndex, pageIndex) {
            if (indexes.pageIndex === pageIndex && indexes.rowIndex === rowIndex && indexes.columnIndex === columnIndex) {
              field = currentField;
            }
          });
          return field;
        }
      }, {
        key: "_getFieldType",
        value: function _getFieldType(fieldName) {
          var _this$props4 = this.props,
              fieldTypes = _this$props4.fieldTypes,
              pages = _this$props4.pages;
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
          var field = visitor.findField(function (field) {
            return field.fieldName === fieldName;
          });
          return field && fieldTypes.find(function (fieldType) {
            return fieldType.name === field.type;
          }).label;
        }
      }, {
        key: "_handleMouseEnterField",
        value: function _handleMouseEnterField(_ref5) {
          var delegateTarget = _ref5.delegateTarget;

          if (!delegateTarget.classList.contains('selected')) {
            var hoveredFieldActions = this.refs.hoveredFieldActions;

            var indexes = _dynamicDataMappingFormRenderer.FormSupport.getIndexes(_metalDom["default"].closest(delegateTarget, '.col-ddm'));

            var _this$_getColumnField = this._getColumnField(indexes),
                fieldName = _this$_getColumnField.fieldName;

            this.showActions(hoveredFieldActions, fieldName);
          }
        }
      }]);

      return ActionableFields;
    }(_metalJsx["default"]);

    ActionableFields.PROPS = {
      /**
       * @default
       * @instance
       * @memberof FormBuilder
       * @type {?number}
       */
      activePage: _metalState.Config.number().value(0),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      defaultLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?(array|undefined)}
       */
      fieldActions: _metalState.Config.array().value([]),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      fieldSetDefinitionURL: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?(array|undefined)}
       */
      fieldSets: _metalState.Config.array().value([]),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?(array|undefined)}
       */
      fieldTypes: _metalState.Config.array().value([]),

      /**
       * @default {}
       * @instance
       * @memberof FormBuilder
       * @type {?object}
       */
      focusedField: _config.focusedFieldStructure.value({}),

      /**
       * @default []
       * @instance
       * @memberof FormBuilder
       * @type {?array<object>}
       */
      pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      paginationMode: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {string}
       */
      portletNamespace: _metalState.Config.string().required(),

      /**
       * @default undefined
       * @instance
       * @memberof FormRenderer
       * @type {!string}
       */
      spritemap: _metalState.Config.string().required(),

      /**
       * @instance
       * @memberof FormBuilder
       * @type {object}
       */
      successPageSettings: _metalState.Config.shapeOf({
        body: _metalState.Config.object(),
        enabled: _metalState.Config.bool(),
        title: _metalState.Config.object()
      }).value({}),

      /**
       * @default undefined
       * @instance
       * @memberof FormBuilder
       * @type {?string}
       */
      view: _metalState.Config.string()
    };
    return ActionableFields;
  };

  var _default = withActionableFields;
  exports["default"] = _default;
  //# sourceMappingURL=withActionableFields.es.js.map
});
//# sourceMappingURL=withActionableFields.es.js.map