Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.85/js/util/dragAndDrop.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', './fieldSupport.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.disableFieldSetDropTargets = exports.disableFieldSetDragSources = exports.disableFieldDropTargets = void 0;

    var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

    var _fieldSupport = require("./fieldSupport.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    var disableFieldDropTargets = function disableFieldDropTargets(element) {
      var dropTargets = element.querySelectorAll('.ddm-target');

      for (var i = 0; i < dropTargets.length; i++) {
        var target = dropTargets[i];

        var parentFieldNode = _metalDom.default.closest(target, '.ddm-field-container');

        if (parentFieldNode) {
          target.setAttribute('data-drop-disabled', true);
        }
      }
    };

    exports.disableFieldDropTargets = disableFieldDropTargets;

    var disableFieldSetDragSources = function disableFieldSetDragSources(element, pages) {
      var dragSources = element.querySelectorAll('.ddm-drag');

      for (var i = 0; i < dragSources.length; i++) {
        var source = dragSources[i];
        var fieldName = source.parentElement.dataset.fieldName;

        if ((0, _fieldSupport.isFieldSetChild)(pages, fieldName)) {
          source.setAttribute('data-drag-disabled', true);
        }
      }
    };

    exports.disableFieldSetDragSources = disableFieldSetDragSources;

    var disableFieldSetDropTargets = function disableFieldSetDropTargets(element, pages) {
      var dropTargets = element.querySelectorAll('.ddm-target');

      for (var i = 0; i < dropTargets.length; i++) {
        var target = dropTargets[i];

        var parentFieldNode = _metalDom.default.closest(target, '.ddm-field-container');

        if (parentFieldNode) {
          var fieldName = parentFieldNode.dataset.fieldName;
          var parentField = (0, _fieldSupport.getField)(pages, fieldName);

          if (parentField && (0, _fieldSupport.isFieldSet)(parentField) || (0, _fieldSupport.isFieldSetChild)(pages, fieldName)) {
            target.setAttribute('data-drop-disabled', true);
          }
        }
      }
    };

    exports.disableFieldSetDropTargets = disableFieldSetDropTargets;
    //# sourceMappingURL=dragAndDrop.es.js.map
  }
});
//# sourceMappingURL=dragAndDrop.es.js.map