Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.82/js/components/LayoutProvider/handlers/fieldSetAddedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../util/fieldset.es', '../util/settingsContext.es', './fieldAddedHandler.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _fieldset = require("../util/fieldset.es");

    var _settingsContext = require("../util/settingsContext.es");

    var _fieldAddedHandler = require("./fieldAddedHandler.es");

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    var handleFieldSetAdded = function handleFieldSetAdded(props, state, event) {
      var defaultLanguageId = event.defaultLanguageId,
          fieldSet = event.fieldSet,
          indexes = event.indexes,
          parentFieldName = event.parentFieldName,
          properties = event.properties,
          rows = event.rows,
          useFieldName = event.useFieldName;
      var pages = state.pages;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(fieldSet.pages);
      var nestedFields = [];
      visitor.mapFields(function (nestedField) {
        nestedFields.push((0, _settingsContext.updateField)(props, nestedField, 'label', nestedField.label[defaultLanguageId]));
      });
      var fieldSetField = (0, _fieldset.createFieldSet)(props, {
        skipFieldNameGeneration: false,
        useFieldName: useFieldName
      }, nestedFields);

      if (properties) {
        Object.keys(properties).forEach(function (key) {
          fieldSetField = (0, _settingsContext.updateField)(props, fieldSetField, key, properties[key]);
        });
      }

      if (fieldSet.id) {
        fieldSetField = (0, _settingsContext.updateField)(props, fieldSetField, 'ddmStructureId', fieldSet.id);
      }

      if (rows && rows.length) {
        fieldSetField = (0, _settingsContext.updateField)(props, fieldSetField, 'rows', rows);
      }

      return (0, _fieldAddedHandler.addField)(props, {
        indexes: indexes,
        newField: (0, _settingsContext.updateField)(props, fieldSetField, 'label', fieldSet.localizedTitle[defaultLanguageId]),
        pages: pages,
        parentFieldName: parentFieldName
      });
    };

    var _default = handleFieldSetAdded;
    exports.default = _default;
    //# sourceMappingURL=fieldSetAddedHandler.es.js.map
  }
});
//# sourceMappingURL=fieldSetAddedHandler.es.js.map