Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.82/js/components/LayoutProvider/handlers/fieldMovedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/constants.es', '../../../util/fieldSupport.es', '../util/settingsContext.es', './fieldAddedHandler.es', './fieldDeletedHandler.es', './sectionAddedHandler.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _constants = require("../../../util/constants.es");

    var _fieldSupport = require("../../../util/fieldSupport.es");

    var _settingsContext = require("../util/settingsContext.es");

    var _fieldAddedHandler = require("./fieldAddedHandler.es");

    var _fieldDeletedHandler = _interopRequireDefault(require("./fieldDeletedHandler.es"));

    var _sectionAddedHandler = _interopRequireDefault(require("./sectionAddedHandler.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var _default = function _default(props, state, event) {
      var sourceFieldName = event.sourceFieldName,
          sourceFieldPage = event.sourceFieldPage,
          targetFieldName = event.targetFieldName,
          targetIndexes = event.targetIndexes,
          targetParentFieldName = event.targetParentFieldName;

      var sourceField = _dynamicDataMappingFormRenderer.FormSupport.findFieldByFieldName(state.pages, sourceFieldName);

      var mergedState = _objectSpread({}, (0, _fieldDeletedHandler.default)(props, state, {
        activePage: sourceFieldPage,
        editRule: false,
        fieldName: sourceFieldName,
        removeEmptyRows: false
      }));

      var parentField = (0, _fieldSupport.getParentField)(state.pages, sourceFieldName);

      if (parentField && targetFieldName && parentField.fieldName === targetFieldName) {
        return state;
      }

      if (parentField && parentField.type === _constants.FIELD_TYPE_FIELDSET && parentField.nestedFields.length === 1) {
        var parentFieldName = parentField ? parentField.fieldName : '';

        do {
          if (parentField) {
            parentFieldName = parentField.fieldName;
          }

          parentField = (0, _fieldSupport.getParentField)(state.pages, parentField.fieldName);
        } while (parentField && parentField.type === _constants.FIELD_TYPE_FIELDSET && parentField.fieldName !== targetParentFieldName && parentField.nestedFields.length === 1);

        if (parentFieldName && parentFieldName !== targetParentFieldName) {
          mergedState = _objectSpread({}, (0, _fieldDeletedHandler.default)(props, state, {
            activePage: sourceFieldPage,
            editRule: false,
            fieldName: parentFieldName,
            removeEmptyRows: false
          }));
        }
      }

      if (targetFieldName) {
        var deletedState = (0, _fieldDeletedHandler.default)(props, state, {
          activePage: sourceFieldPage,
          editRule: false,
          fieldName: sourceFieldName
        });
        return _objectSpread({}, (0, _sectionAddedHandler.default)(props, _objectSpread(_objectSpread({}, state), {}, {
          pages: deletedState.pages
        }), {
          data: {
            fieldName: targetFieldName,
            parentFieldName: targetParentFieldName
          },
          indexes: targetIndexes,
          newField: sourceField
        }));
      }

      var addedState = (0, _fieldAddedHandler.addField)(props, {
        indexes: targetIndexes,
        newField: sourceField,
        pages: mergedState.pages,
        parentFieldName: targetParentFieldName
      });
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(addedState.pages);
      var pages = visitor.mapFields(function (field) {
        if (field.type != 'grid' && field.rows) {
          return (0, _settingsContext.updateField)(props, field, 'rows', _dynamicDataMappingFormRenderer.FormSupport.removeEmptyRows([field], 0));
        }

        return field;
      });
      return _objectSpread(_objectSpread({}, addedState), {}, {
        pages: pages.map(function (page, pageIndex) {
          if (sourceFieldPage === pageIndex) {
            return _objectSpread(_objectSpread({}, page), {}, {
              rows: _dynamicDataMappingFormRenderer.FormSupport.removeEmptyRows(pages, pageIndex)
            });
          }

          return page;
        })
      });
    };

    exports.default = _default;
    //# sourceMappingURL=fieldMovedHandler.es.js.map
  }
});
//# sourceMappingURL=fieldMovedHandler.es.js.map