Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.74/js/expressions/Tokenizer.es", ['module', 'exports', 'require', './Token.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _Token = _interopRequireDefault(require("./Token.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    var OPERATORS = ['*', '/', '+', '-'];
    /**
     * Tokenizer.
     * Transforms an expression into tokens and token into an expression
     */

    var Tokenizer = /*#__PURE__*/function () {
      function Tokenizer() {
        _classCallCheck(this, Tokenizer);
      }

      _createClass(Tokenizer, null, [{
        key: "stringifyTokens",
        value: function stringifyTokens(tokens) {
          return tokens.reduce(function (expression, token) {
            var value = token.value;

            if (token.type === _Token.default.VARIABLE) {
              value = "[".concat(value, "]");
            }

            return expression + value;
          }, '');
        }
      }, {
        key: "tokenize",
        value: function tokenize(str) {
          var result = [];
          str = str.replace(/\s/g, '');
          var functionBuffer = [];
          var numberBuffer = [];
          var variableBuffer = [];

          var emptyNumberBuffer = function emptyNumberBuffer() {
            if (numberBuffer.length) {
              result.push(new _Token.default(_Token.default.LITERAL, numberBuffer.join('')));
              numberBuffer = [];
            }
          };

          var emptyFunctionBuffer = function emptyFunctionBuffer() {
            result.push(new _Token.default(_Token.default.FUNCTION, functionBuffer.join('')));
            functionBuffer = [];
          };

          var emptyVariableBuffer = function emptyVariableBuffer() {
            result.push(new _Token.default(_Token.default.VARIABLE, variableBuffer.join('')));
            variableBuffer = [];
          };

          var inputBuffer = str.split('');

          while (inputBuffer.length) {
            var char = inputBuffer.shift();

            if (this.isDigit(char)) {
              numberBuffer.push(char);
            } else if (char === '.') {
              numberBuffer.push(char);
            } else if (this.isLeftBracket(char)) {
              if (numberBuffer.length) {
                emptyNumberBuffer();
                result.push(new _Token.default(_Token.default.OPERATOR, '*'));
              }

              do {
                char = inputBuffer.shift();

                if (this.isRightBracket(char)) {
                  emptyVariableBuffer();
                  break;
                } else {
                  variableBuffer.push(char);
                }
              } while (inputBuffer.length);
            } else if (this.isLetter(char)) {
              if (numberBuffer.length) {
                emptyNumberBuffer();
                result.push(new _Token.default(_Token.default.OPERATOR, '*'));
              }

              do {
                functionBuffer.push(char);
                char = inputBuffer.shift();
              } while (this.isLetter(char));

              if (char !== undefined) {
                inputBuffer.unshift(char);
              }

              emptyFunctionBuffer();
            } else if (this.isOperator(char)) {
              emptyNumberBuffer();
              result.push(new _Token.default(_Token.default.OPERATOR, char));
            } else if (this.isLeftParenthesis(char)) {
              if (numberBuffer.length) {
                emptyNumberBuffer();
                result.push(new _Token.default(_Token.default.OPERATOR, '*'));
              }

              result.push(new _Token.default(_Token.default.LEFT_PARENTHESIS, char));
            } else if (this.isRightParenthesis(char)) {
              emptyNumberBuffer();
              result.push(new _Token.default(_Token.default.RIGHT_PARENTHESIS, char));
            } else {
              throw new Error("Unsupported character ".concat(char));
            }
          }

          if (numberBuffer.length) {
            emptyNumberBuffer();
          }

          if (variableBuffer.length) {
            emptyVariableBuffer();
          }

          return result;
        }
      }, {
        key: "isDigit",
        value: function isDigit(char) {
          return char !== undefined && /[0-9]/.test(char);
        }
      }, {
        key: "isLetter",
        value: function isLetter(char) {
          return char !== undefined && /[a-zA-Z]/.test(char);
        }
      }, {
        key: "isLeftBracket",
        value: function isLeftBracket(char) {
          return char === '[';
        }
      }, {
        key: "isRightBracket",
        value: function isRightBracket(char) {
          return char === ']';
        }
      }, {
        key: "isLeftParenthesis",
        value: function isLeftParenthesis(char) {
          return char === '(';
        }
      }, {
        key: "isRightParenthesis",
        value: function isRightParenthesis(char) {
          return char === ')';
        }
      }, {
        key: "isOperator",
        value: function isOperator(char) {
          return OPERATORS.includes(char);
        }
      }]);

      return Tokenizer;
    }();

    var _default = Tokenizer;
    exports.default = _default;
    //# sourceMappingURL=Tokenizer.es.js.map
  }
});
//# sourceMappingURL=Tokenizer.es.js.map