Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.74/js/components/LayoutProvider/handlers/fieldEditedPropertiesHandler.es", ['module', 'exports', 'require', '../../../util/fieldSupport.es', '../util/rules.es', '../util/settingsContext.es', './fieldEditedHandler.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _fieldSupport = require("../../../util/fieldSupport.es");

    var _rules = require("../util/rules.es");

    var _settingsContext = require("../util/settingsContext.es");

    var _fieldEditedHandler = require("./fieldEditedHandler.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var updateState = function updateState(props, state, properties) {
      var activePage = state.activePage,
          focusedField = state.focusedField,
          pages = state.pages,
          rules = state.rules;
      var previousFocusedFieldName = focusedField.fieldName;
      var newFocusedField;
      var defaultLanguageId = props.defaultLanguageId;

      if (properties.length === 1) {
        var _properties = _slicedToArray(properties, 1),
            _properties$ = _properties[0],
            name = _properties$.name,
            value = _properties$.value;

        newFocusedField = (0, _settingsContext.updateField)(props, focusedField, name, value);
      } else {
        newFocusedField = properties.reduce(function (initialField, _ref, index) {
          var name = _ref.name,
              value = _ref.value;
          var useField = initialField;

          if (index === 1) {
            if (initialField.name === 'nestedFields') {
              initialField.value = initialField.value.map(function (nestedField) {
                return (0, _settingsContext.updateField)(props, nestedField, 'label', nestedField.label[defaultLanguageId]);
              });
            }

            useField = (0, _settingsContext.updateField)(props, focusedField, initialField.name, initialField.value);
          }

          return (0, _settingsContext.updateField)(props, useField, name, value);
        });
      }

      var newPages = (0, _fieldEditedHandler.updatePages)(props, pages, previousFocusedFieldName, newFocusedField);
      return {
        activePage: activePage,
        focusedField: newFocusedField,
        pages: newPages,
        rules: (0, _rules.updateRulesReferences)(rules || [], focusedField, newFocusedField)
      };
    };

    var _default = function _default(props, state, event) {
      var fieldName = event.fieldName,
          properties = event.properties;

      if (!Array.isArray(properties) || !properties.length) {
        return;
      }

      properties.filter(function (_ref2) {
        var name = _ref2.name,
            value = _ref2.value;
        return name !== 'name' || value !== '';
      });
      state = _objectSpread(_objectSpread({}, state), fieldName && {
        focusedField: (0, _fieldSupport.getField)(state.pages, fieldName)
      });
      return updateState(props, state, properties);
    };

    exports.default = _default;
    //# sourceMappingURL=fieldEditedPropertiesHandler.es.js.map
  }
});
//# sourceMappingURL=fieldEditedPropertiesHandler.es.js.map