/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.servlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.role.RoleConstants;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ContentTypes;

import java.io.IOException;

import java.util.List;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Rafael Praxedes
 */
@Component(
	immediate = true,
	property = {
		"dynamic.data.mapping.form.builder.servlet=true",
		"osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-builder-roles",
		"osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.builder.internal.servlet.RolesServlet",
		"osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-builder-roles/*"
	},
	service = Servlet.class
)
public class RolesServlet extends BaseDDMFormBuilderServlet {

	@Override
	protected void doGet(
			HttpServletRequest httpServletRequest,
			HttpServletResponse httpServletResponse)
		throws IOException, ServletException {

		JSONArray jsonArray = getRolesJSONArray();

		httpServletResponse.setContentType(ContentTypes.APPLICATION_JSON);
		httpServletResponse.setStatus(HttpServletResponse.SC_OK);

		ServletResponseUtil.write(httpServletResponse, jsonArray.toString());
	}

	protected JSONArray getRolesJSONArray() {
		JSONArray jsonArray = _jsonFactory.createJSONArray();

		try {
			List<Role> roles = _roleService.getRoles(
				CompanyThreadLocal.getCompanyId(),
				new int[] {
					RoleConstants.TYPE_ORGANIZATION, RoleConstants.TYPE_REGULAR,
					RoleConstants.TYPE_SITE
				});

			for (Role role : roles) {
				jsonArray.put(toJSONObject(role));
			}

			return jsonArray;
		}
		catch (PortalException portalException) {
			if (_log.isDebugEnabled()) {
				_log.debug(portalException, portalException);
			}
		}

		return jsonArray;
	}

	protected JSONObject toJSONObject(Role role) {
		JSONObject jsonObject = _jsonFactory.createJSONObject();

		jsonObject.put(
			"id", role.getRoleId()
		).put(
			"name", role.getName()
		);

		return jsonObject;
	}

	private static final Log _log = LogFactoryUtil.getLog(RolesServlet.class);

	private static final long serialVersionUID = 1L;

	@Reference
	private JSONFactory _jsonFactory;

	@Reference
	private RoleService _roleService;

}