/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer;

import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.JumpToPageDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.spi.converter.serializer.SPIDDMFormRuleActionSerializer;
import com.liferay.dynamic.data.mapping.spi.converter.serializer.SPIDDMFormRuleSerializerContext;
import com.liferay.portal.kernel.util.Validator;

/**
 * @author Leonardo Barros
 */
public class JumpToPageDDMFormRuleActionSerializer
	implements SPIDDMFormRuleActionSerializer {

	public JumpToPageDDMFormRuleActionSerializer(
		JumpToPageDDMFormRuleAction jumpToPageDDMFormRuleAction) {

		_jumpToPageDDMFormRuleAction = jumpToPageDDMFormRuleAction;
	}

	@Override
	public String serialize(
		SPIDDMFormRuleSerializerContext spiDDMFormRuleSerializerContext) {

		if (Validator.isNull(_jumpToPageDDMFormRuleAction.getTarget())) {
			return null;
		}

		return String.format(
			_FUNCTION_CALL_BINARY_EXPRESSION_FORMAT, "jumpPage",
			_jumpToPageDDMFormRuleAction.getSource(),
			_jumpToPageDDMFormRuleAction.getTarget());
	}

	private static final String _FUNCTION_CALL_BINARY_EXPRESSION_FORMAT =
		"%s(%s, %s)";

	private final JumpToPageDDMFormRuleAction _jumpToPageDDMFormRuleAction;

}