/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'dynamic-data-mapping-form-renderer';

import {getField} from '../util/fields.es';
import handleFieldEdited from './fieldEditedHandler.es';

const handleFocusedFieldEvaluationEnded = (
	props,
	state,
	changedEditingLanguage = false,
	changedFieldType = false,
	instanceId,
	settingsContext
) => {
	if (changedEditingLanguage) {
		return state;
	}

	const fieldName = getField(settingsContext.pages, 'name');
	const {focusedField} = state;
	const focusedFieldName = getField(
		focusedField.settingsContext.pages,
		'name'
	);

	if (
		fieldName.instanceId !== focusedFieldName.instanceId &&
		!changedFieldType
	) {
		return state;
	}

	state = {
		...state,
		focusedField: {
			...focusedField,
			instanceId: instanceId || focusedField.instanceId,
			settingsContext,
		},
	};

	const visitor = new PagesVisitor(settingsContext.pages);

	visitor.mapFields(({fieldName, value}) => {
		state = handleFieldEdited(props, state, {
			propertyName: fieldName,
			propertyValue: value,
		});
	});

	return state;
};

export default handleFocusedFieldEvaluationEnded;
