Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.64/js/components/LayoutProvider/handlers/fieldEditedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../../../util/fieldSupport.es', '../util/rules.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.handleFieldEdited = exports.findInvalidFieldReference = exports.updateState = exports.updatePages = void 0;

    var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

    var _fieldSupport = require("../../../util/fieldSupport.es");

    var _rules = require("../util/rules.es");

    var _settingsContext = require("../util/settingsContext.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var updatePages = function updatePages(props, pages, previousFieldName, newField) {
      var parentFieldName;
      var visitor = new _visitors.PagesVisitor(pages);
      var newFieldName = newField.fieldName;
      var newPages = visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex, parentField) {
        if (field.fieldName === previousFieldName) {
          if (parentField) {
            parentFieldName = parentField.fieldName;
          }

          return newField;
        }

        return field;
      }, true, true);

      if (parentFieldName && previousFieldName !== newFieldName) {
        visitor.setPages(newPages);
        newPages = visitor.mapFields(function (field) {
          if (parentFieldName === field.fieldName) {
            var _visitor = new _visitors.PagesVisitor([{
              rows: field.rows || []
            }]);

            var layout = _visitor.mapColumns(function (column) {
              return _objectSpread(_objectSpread({}, column), {}, {
                fields: column.fields.map(function (fieldName) {
                  if (fieldName === previousFieldName) {
                    return newFieldName;
                  }

                  return fieldName;
                })
              });
            });

            var rows = layout[0].rows;
            return _objectSpread(_objectSpread({}, field), {}, {
              rows: rows,
              settingsContext: (0, _settingsContext.updateSettingsContextProperty)(props.editingLanguageId, field.settingsContext, 'rows', rows)
            });
          }

          return field;
        }, true, true);
      }

      return newPages;
    };

    exports.updatePages = updatePages;

    var updateState = function updateState(props, state, propertyName, propertyValue) {
      var activePage = state.activePage,
          focusedField = state.focusedField,
          pages = state.pages,
          rules = state.rules;
      var previousFocusedFieldName = focusedField.fieldName;
      var newFocusedField = (0, _settingsContext.updateField)(props, focusedField, propertyName, propertyValue);
      var newPages = updatePages(props, pages, previousFocusedFieldName, newFocusedField);
      return {
        activePage: activePage,
        focusedField: newFocusedField,
        pages: newPages,
        rules: (0, _rules.updateRulesReferences)(rules || [], focusedField, newFocusedField)
      };
    };

    exports.updateState = updateState;

    var findInvalidFieldReference = function findInvalidFieldReference(focusedField, pages, value) {
      var hasInvalidFieldReference = false;
      var visitor = new _visitors.PagesVisitor(pages);
      visitor.mapFields(function (field) {
        var fieldReference = (0, _settingsContext.getSettingsContextProperty)(field.settingsContext, 'fieldReference');

        if (focusedField.fieldName !== field.fieldName && fieldReference === value) {
          hasInvalidFieldReference = true;
        }
      });
      return hasInvalidFieldReference;
    };

    exports.findInvalidFieldReference = findInvalidFieldReference;

    var handleFieldEdited = function handleFieldEdited(props, state, event) {
      var fieldName = event.fieldName,
          propertyName = event.propertyName,
          propertyValue = event.propertyValue;
      var newState = {};

      if (propertyName !== 'name' || propertyValue !== '') {
        state = _objectSpread(_objectSpread({}, state), fieldName && {
          focusedField: (0, _fieldSupport.getField)(state.pages, fieldName)
        });

        if (propertyName === 'fieldReference' && propertyValue !== '' && propertyValue !== state.focusedField.fieldName) {
          state = _objectSpread(_objectSpread({}, state), {}, {
            focusedField: (0, _settingsContext.updateFieldReference)(state.focusedField, findInvalidFieldReference(state.focusedField, state.pages, propertyValue), false)
          });
        }

        newState = updateState(props, state, propertyName, propertyValue);
      }

      return newState;
    };

    exports.handleFieldEdited = handleFieldEdited;
    var _default = handleFieldEdited;
    exports.default = _default;
    //# sourceMappingURL=fieldEditedHandler.es.js.map
  }
});
//# sourceMappingURL=fieldEditedHandler.es.js.map