Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.64/js/components/LayoutProvider/handlers/fieldDuplicatedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/fieldSupport.es', '../../../util/strings.es', '../util/fields.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.duplicateField = exports.createDuplicatedField = exports.getValidation = exports.getLabel = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _fieldSupport = require("../../../util/fieldSupport.es");

    var _strings = require("../../../util/strings.es");

    var _fields = require("../util/fields.es");

    var _settingsContext = require("../util/settingsContext.es");

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var getLabel = function getLabel(originalField, editingLanguageId) {
      return (0, _strings.sub)(Liferay.Language.get('copy-of-x'), [(0, _fields.getFieldLocalizedValue)(originalField.settingsContext.pages, 'label', editingLanguageId)]);
    };

    exports.getLabel = getLabel;

    var getValidation = function getValidation(originalField) {
      var validation = (0, _settingsContext.getSettingsContextProperty)(originalField.settingsContext, 'validation');
      return validation;
    };

    exports.getValidation = getValidation;

    var createDuplicatedField = function createDuplicatedField(originalField, props) {
      var _duplicatedField$nest;

      var blacklist = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      var editingLanguageId = props.editingLanguageId,
          fieldNameGenerator = props.fieldNameGenerator;
      var newFieldName = fieldNameGenerator((0, _fieldSupport.getDefaultFieldName)(), null, blacklist);
      var duplicatedField = (0, _settingsContext.updateField)(props, originalField, 'name', newFieldName);
      duplicatedField = (0, _settingsContext.updateField)(props, duplicatedField, 'fieldReference', newFieldName);
      duplicatedField.instanceId = (0, _dynamicDataMappingFormRenderer.generateInstanceId)(8);
      var label = getLabel(originalField, editingLanguageId);
      duplicatedField = (0, _settingsContext.updateField)(props, duplicatedField, 'label', label);

      if (((_duplicatedField$nest = duplicatedField.nestedFields) === null || _duplicatedField$nest === void 0 ? void 0 : _duplicatedField$nest.length) > 0) {
        duplicatedField.nestedFields = duplicatedField.nestedFields.map(function (field) {
          var _duplicatedField$rows;

          var newDuplicatedNestedField = createDuplicatedField(field, props, blacklist);
          blacklist.push(newDuplicatedNestedField.fieldName);
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor([{
            rows: (_duplicatedField$rows = duplicatedField.rows) !== null && _duplicatedField$rows !== void 0 ? _duplicatedField$rows : []
          }]);
          var layout = visitor.mapColumns(function (column) {
            return _objectSpread(_objectSpread({}, column), {}, {
              fields: column.fields.map(function (fieldName) {
                if (fieldName === field.fieldName) {
                  return newDuplicatedNestedField.fieldName;
                }

                return fieldName;
              })
            });
          });
          duplicatedField.rows = layout[0].rows;
          return newDuplicatedNestedField;
        });
        duplicatedField.settingsContext = (0, _settingsContext.updateSettingsContextProperty)(props.editingLanguageId, duplicatedField.settingsContext, 'rows', duplicatedField.rows);
      }

      duplicatedField.settingsContext = (0, _settingsContext.updateSettingsContextInstanceId)(duplicatedField);
      return (0, _settingsContext.updateField)(props, duplicatedField, 'validation', getValidation(duplicatedField));
    };

    exports.createDuplicatedField = createDuplicatedField;

    var duplicateField = function duplicateField(activePage, props, pages, originalField, duplicatedField) {
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);

      var parentField = _dynamicDataMappingFormRenderer.FormSupport.getParentField(pages, originalField.fieldName);

      if (parentField) {
        return visitor.mapFields(function (field) {
          if (field.fieldName === parentField.fieldName) {
            var nestedFields = field.nestedFields ? [].concat(_toConsumableArray(field.nestedFields), [duplicatedField]) : [duplicatedField];
            field = (0, _settingsContext.updateField)(props, field, 'nestedFields', nestedFields);
            var _pages = [{
              rows: field.rows
            }];

            var _FormSupport$getField = _dynamicDataMappingFormRenderer.FormSupport.getFieldIndexes(_pages, originalField.fieldName),
                _rowIndex = _FormSupport$getField.rowIndex;

            var _newRow = _dynamicDataMappingFormRenderer.FormSupport.implAddRow(12, [duplicatedField.fieldName]);

            _pages = _dynamicDataMappingFormRenderer.FormSupport.addRow(_pages, _rowIndex + 1, activePage, _newRow);
            return (0, _settingsContext.updateField)(props, field, 'rows', _pages[0].rows);
          }

          return field;
        }, true, true);
      }

      var _FormSupport$getField2 = _dynamicDataMappingFormRenderer.FormSupport.getFieldIndexes(pages, originalField.fieldName),
          rowIndex = _FormSupport$getField2.rowIndex;

      var newRow = _dynamicDataMappingFormRenderer.FormSupport.implAddRow(12, [duplicatedField]);

      return _dynamicDataMappingFormRenderer.FormSupport.addRow(pages, rowIndex + 1, activePage, newRow);
    };

    exports.duplicateField = duplicateField;

    var handleFieldDuplicated = function handleFieldDuplicated(props, state, _ref) {
      var activePage = _ref.activePage,
          fieldName = _ref.fieldName;
      var pages = state.pages;

      if (activePage === undefined) {
        activePage = state.activePage;
      }

      var originalField = JSON.parse(JSON.stringify(_dynamicDataMappingFormRenderer.FormSupport.findFieldByFieldName(pages, fieldName)));
      var duplicatedField = createDuplicatedField(originalField, props);
      return {
        focusedField: _objectSpread({}, duplicatedField),
        pages: duplicateField(activePage, props, pages, originalField, duplicatedField)
      };
    };

    var _default = handleFieldDuplicated;
    exports.default = _default;
    //# sourceMappingURL=fieldDuplicatedHandler.es.js.map
  }
});
//# sourceMappingURL=fieldDuplicatedHandler.es.js.map