Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.64/js/components/LayoutProvider/handlers/fieldDeletedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/constants.es', '../../RuleBuilder/RulesSupport.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.handleFieldDeleted = exports.removeField = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _constants = require("../../../util/constants.es");

    var _RulesSupport = _interopRequireDefault(require("../../RuleBuilder/RulesSupport.es"));

    var _settingsContext = require("../util/settingsContext.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var removeField = function removeField(props, pages, fieldName) {
      var removeEmptyRows = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);

      var filter = function filter(fields) {
        return fields.filter(function (field) {
          return field.fieldName !== fieldName;
        }).map(function (field) {
          var nestedFields = field.nestedFields ? filter(field.nestedFields) : [];
          field = (0, _settingsContext.updateField)(props, field, 'nestedFields', nestedFields);

          if (field.type !== _constants.FIELD_TYPE_FIELDSET) {
            return _objectSpread(_objectSpread({}, field), {}, {
              nestedFields: nestedFields
            });
          }

          var rows = [];

          if (field.rows) {
            var _visitor = new _dynamicDataMappingFormRenderer.PagesVisitor([{
              rows: typeof field.rows === 'string' ? JSON.parse(field.rows) : field.rows || []
            }]);

            var _pages = _visitor.mapColumns(function (column) {
              return _objectSpread(_objectSpread({}, column), {}, {
                fields: column.fields.filter(function (nestedFieldName) {
                  return fieldName !== nestedFieldName;
                })
              });
            });

            rows = removeEmptyRows ? _dynamicDataMappingFormRenderer.FormSupport.removeEmptyRows(_pages, 0) : _pages[0].rows;
            field = (0, _settingsContext.updateField)(props, field, 'rows', rows);
          }

          return _objectSpread(_objectSpread({}, field), {}, {
            nestedFields: nestedFields,
            rows: rows
          });
        });
      };

      return visitor.mapColumns(function (column) {
        return _objectSpread(_objectSpread({}, column), {}, {
          fields: filter(column.fields)
        });
      });
    };

    exports.removeField = removeField;

    var handleFieldDeleted = function handleFieldDeleted(props, state, _ref) {
      var activePage = _ref.activePage,
          _ref$editRule = _ref.editRule,
          editRule = _ref$editRule === void 0 ? true : _ref$editRule,
          fieldName = _ref.fieldName,
          _ref$removeEmptyRows = _ref.removeEmptyRows,
          removeEmptyRows = _ref$removeEmptyRows === void 0 ? true : _ref$removeEmptyRows;
      var pages = state.pages;

      if (activePage === undefined) {
        activePage = state.activePage;
      }

      var newPages = pages.map(function (page, pageIndex) {
        if (activePage === pageIndex) {
          var pagesWithFieldRemoved = removeField(props, pages, fieldName, removeEmptyRows);
          return _objectSpread(_objectSpread({}, page), {}, {
            rows: removeEmptyRows ? _dynamicDataMappingFormRenderer.FormSupport.removeEmptyRows(pagesWithFieldRemoved, pageIndex) : pagesWithFieldRemoved[pageIndex].rows
          });
        }

        return page;
      });
      return {
        focusedField: {},
        pages: newPages,
        rules: editRule ? _RulesSupport.default.formatRules(newPages, state.rules) : state.rules
      };
    };

    exports.handleFieldDeleted = handleFieldDeleted;
    var _default = handleFieldDeleted;
    exports.default = _default;
    //# sourceMappingURL=fieldDeletedHandler.es.js.map
  }
});
//# sourceMappingURL=fieldDeletedHandler.es.js.map