Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.64/js/components/LayoutProvider/LayoutProvider.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', 'frontend-js-web', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state', '../../components/RuleBuilder/RulesSupport.es', '../../util/config.es', '../../util/fieldSupport.es', '../../util/i18n.es', './handlers/columnResizedHandler.es', './handlers/elementSetAddedHandler.es', './handlers/fieldAddedHandler.es', './handlers/fieldBlurredHandler.es', './handlers/fieldClickedHandler.es', './handlers/fieldDeletedHandler.es', './handlers/fieldDuplicatedHandler.es', './handlers/fieldEditedHandler.es', './handlers/fieldEditedPropertiesHandler.es', './handlers/fieldMovedHandler.es', './handlers/fieldSetAddedHandler.es', './handlers/focusedFieldEvaluationEndedHandler.es', './handlers/languageIdDeletedHandler.es', './handlers/sectionAddedHandler.es', './util/fields.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _frontendJsWeb = require("frontend-js-web");

    var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

    var _metalState = require("frontend-js-metal-web$metal-state");

    var _RulesSupport = _interopRequireDefault(require("../../components/RuleBuilder/RulesSupport.es"));

    var _config = require("../../util/config.es");

    var _fieldSupport = require("../../util/fieldSupport.es");

    var _i18n = require("../../util/i18n.es");

    var _columnResizedHandler = _interopRequireDefault(require("./handlers/columnResizedHandler.es"));

    var _elementSetAddedHandler = _interopRequireDefault(require("./handlers/elementSetAddedHandler.es"));

    var _fieldAddedHandler = _interopRequireDefault(require("./handlers/fieldAddedHandler.es"));

    var _fieldBlurredHandler = _interopRequireDefault(require("./handlers/fieldBlurredHandler.es"));

    var _fieldClickedHandler = _interopRequireDefault(require("./handlers/fieldClickedHandler.es"));

    var _fieldDeletedHandler = _interopRequireDefault(require("./handlers/fieldDeletedHandler.es"));

    var _fieldDuplicatedHandler = _interopRequireDefault(require("./handlers/fieldDuplicatedHandler.es"));

    var _fieldEditedHandler = _interopRequireDefault(require("./handlers/fieldEditedHandler.es"));

    var _fieldEditedPropertiesHandler = _interopRequireDefault(require("./handlers/fieldEditedPropertiesHandler.es"));

    var _fieldMovedHandler = _interopRequireDefault(require("./handlers/fieldMovedHandler.es"));

    var _fieldSetAddedHandler = _interopRequireDefault(require("./handlers/fieldSetAddedHandler.es"));

    var _focusedFieldEvaluationEndedHandler = _interopRequireDefault(require("./handlers/focusedFieldEvaluationEndedHandler.es"));

    var _languageIdDeletedHandler = _interopRequireDefault(require("./handlers/languageIdDeletedHandler.es"));

    var _sectionAddedHandler = _interopRequireDefault(require("./handlers/sectionAddedHandler.es"));

    var _fields = require("./util/fields.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    /**
     * LayoutProvider listens to your children's events to
     * control the `pages` and make manipulations.
     * @extends Component
     */
    var LayoutProvider = /*#__PURE__*/function (_Component) {
      _inherits(LayoutProvider, _Component);

      function LayoutProvider() {
        _classCallCheck(this, LayoutProvider);

        return _possibleConstructorReturn(this, _getPrototypeOf(LayoutProvider).apply(this, arguments));
      }

      _createClass(LayoutProvider, [{
        key: "createNewPage",
        value: function createNewPage() {
          var languageId = this.props.editingLanguageId;
          var page = {
            description: '',
            enabled: true,
            rows: [_dynamicDataMappingFormRenderer.FormSupport.implAddRow(12, [])],
            showRequiredFieldsWarning: true,
            title: ''
          };
          (0, _i18n.setLocalizedValue)(page, languageId, 'title', '');
          (0, _i18n.setLocalizedValue)(page, languageId, 'description', '');
          return page;
        }
      }, {
        key: "dispatch",
        value: function dispatch(event, payload) {
          try {
            this.emit(event, payload);
          } catch (e) {
            (0, _frontendJsWeb.openToast)({
              message: e.message,
              type: 'danger'
            });
          }
        }
      }, {
        key: "getChildContext",
        value: function getChildContext() {
          return {
            dispatch: this.dispatch.bind(this),
            store: this
          };
        }
      }, {
        key: "getEvents",
        value: function getEvents() {
          return {
            activePageUpdated: this._handleActivePageUpdated.bind(this),
            columnResized: this._handleColumnResized.bind(this),
            elementSetAdded: this._handleElementSetAdded.bind(this),
            fieldAdded: this._handleFieldAdded.bind(this),
            fieldBlurred: this._handleFieldBlurred.bind(this),
            fieldChangesCanceled: this._handleFieldChangesCanceled.bind(this),
            fieldClicked: this._handleFieldClicked.bind(this),
            fieldDeleted: this._handleFieldDeleted.bind(this),
            fieldDuplicated: this._handleFieldDuplicated.bind(this),
            fieldEdited: this._handleFieldEdited.bind(this),
            fieldEditedProperties: this._handleFieldEditedProperties.bind(this),
            fieldHovered: this._handleFieldHovered.bind(this),
            fieldMoved: this._handleFieldMoved.bind(this),
            fieldSetAdded: this._handleFieldSetAdded.bind(this),
            focusedFieldEvaluationEnded: this._handleFocusedFieldEvaluationEnded.bind(this),
            languageIdDeleted: this._handleLanguageIdDeleted.bind(this),
            pageAdded: this._handlePageAdded.bind(this),
            pageDeleted: this._handlePageDeleted.bind(this),
            pageReset: this._handlePageReset.bind(this),
            pagesSwapped: this._handlePagesSwapped.bind(this),
            pagesUpdated: this._handlePagesUpdated.bind(this),
            paginationModeUpdated: this._handlePaginationModeUpdated.bind(this),
            paginationNextClicked: this._handlePaginationNextClicked.bind(this),
            paginationPreviousClicked: this._handlePaginationPreviousClicked.bind(this),
            ruleAdded: this._handleRuleAdded.bind(this),
            ruleDeleted: this._handleRuleDeleted.bind(this),
            ruleEdited: this._handleRuleSaved.bind(this),
            ruleSaved: this._handleRuleSaved.bind(this),
            ruleValidatorChanged: this._handleRuleValidatorChanged.bind(this),
            sectionAdded: this._handleSectionAdded.bind(this),
            sidebarFieldBlurred: this._handleSidebarFieldBlurred.bind(this),
            successPageChanged: this._handleSuccessPageChanged.bind(this)
          };
        }
      }, {
        key: "getFocusedField",
        value: function getFocusedField() {
          var _this$props = this.props,
              defaultLanguageId = _this$props.defaultLanguageId,
              editingLanguageId = _this$props.editingLanguageId;
          var focusedField = this.state.focusedField;

          if (focusedField && focusedField.settingsContext) {
            var settingsContext = _objectSpread(_objectSpread({}, focusedField.settingsContext), {}, {
              pages: this.getLocalizedPages(focusedField.settingsContext.pages)
            });

            focusedField = _objectSpread(_objectSpread(_objectSpread({}, focusedField), (0, _fieldSupport.getFieldProperties)(settingsContext, defaultLanguageId, editingLanguageId)), {}, {
              settingsContext: settingsContext
            });
          }

          return focusedField;
        }
      }, {
        key: "getLocalizedPages",
        value: function getLocalizedPages(pages) {
          var _this$props2 = this.props,
              defaultLanguageId = _this$props2.defaultLanguageId,
              editingLanguageId = _this$props2.editingLanguageId;
          var settingsVisitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
          return settingsVisitor.mapFields(function (field) {
            return (0, _fieldSupport.localizeField)(field, defaultLanguageId, editingLanguageId);
          });
        }
      }, {
        key: "getPages",
        value: function getPages() {
          var _this = this;

          var _this$props3 = this.props,
              defaultLanguageId = _this$props3.defaultLanguageId,
              editingLanguageId = _this$props3.editingLanguageId;
          var _this$props$available = this.props.availableLanguageIds,
              availableLanguageIds = _this$props$available === void 0 ? [editingLanguageId] : _this$props$available;
          var _this$state = this.state,
              fieldHovered = _this$state.fieldHovered,
              focusedField = _this$state.focusedField;
          var pages = this.state.pages;
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
          pages = visitor.mapFields(function (field) {
            var settingsContext = field.settingsContext;

            var newSettingsContext = _objectSpread(_objectSpread({}, settingsContext), {}, {
              availableLanguageIds: availableLanguageIds,
              defaultLanguageId: defaultLanguageId,
              pages: _this.getLocalizedPages(settingsContext.pages)
            });

            var newField = _objectSpread(_objectSpread({}, (0, _fieldSupport.getFieldProperties)(newSettingsContext, defaultLanguageId, editingLanguageId)), {}, {
              hovered: fieldHovered.fieldName === field.fieldName,
              name: (0, _dynamicDataMappingFormRenderer.generateName)(field.name, {
                instanceId: field.instanceId || (0, _fieldSupport.generateInstanceId)(),
                repeatedIndex: (0, _dynamicDataMappingFormRenderer.getRepeatedIndex)(field.name)
              }),
              selected: focusedField.fieldName === field.fieldName,
              settingsContext: newSettingsContext
            });

            if (field.type === 'select' && field.dataSourceType && field.dataSourceType.includes('data-provider')) {
              return _objectSpread(_objectSpread({}, newField), {}, {
                options: field.options
              });
            }

            return newField;
          }, true, true);
          visitor.setPages(pages);
          return visitor.mapPages(function (page) {
            var description = page.description,
                title = page.title;

            if (page.localizedDescription[editingLanguageId]) {
              description = page.localizedDescription[editingLanguageId];
            } else if (page.localizedDescription[defaultLanguageId] && page.localizedDescription[editingLanguageId] === undefined) {
              description = page.localizedDescription[defaultLanguageId];
            }

            if (page.localizedTitle[editingLanguageId]) {
              title = page.localizedTitle[editingLanguageId];
            } else if (page.localizedTitle[defaultLanguageId] && page.localizedTitle[editingLanguageId] === undefined) {
              title = page.localizedTitle[defaultLanguageId];
            }

            return _objectSpread(_objectSpread({}, page), {}, {
              description: description,
              title: title
            });
          });
        }
      }, {
        key: "getPaginationMode",
        value: function getPaginationMode() {
          var allowMultiplePages = this.props.allowMultiplePages;
          var paginationMode = this.state.paginationMode;

          if (allowMultiplePages) {
            return paginationMode;
          }

          return 'single-page';
        }
      }, {
        key: "getRules",
        value: function getRules() {
          var rules = this.state.rules;

          if (rules) {
            var visitor = new _dynamicDataMappingFormRenderer.RulesVisitor(rules);
            rules = visitor.mapConditions(function (condition) {
              if (condition.operands[0].type == 'list') {
                condition = _objectSpread(_objectSpread({}, condition), {}, {
                  operands: [{
                    label: 'user',
                    repeatable: false,
                    type: 'user',
                    value: 'user'
                  }, _objectSpread(_objectSpread({}, condition.operands[0]), {}, {
                    label: condition.operands[0].value
                  })]
                });
              }

              return condition;
            });
          }

          return rules;
        }
      }, {
        key: "render",
        value: function render() {
          var _this2 = this;

          var _this$props4 = this.props,
              allowSuccessPage = _this$props4.allowSuccessPage,
              children = _this$props4.children,
              defaultLanguageId = _this$props4.defaultLanguageId,
              editingLanguageId = _this$props4.editingLanguageId,
              fieldActions = _this$props4.fieldActions,
              spritemap = _this$props4.spritemap;
          var _this$state2 = this.state,
              activePage = _this$state2.activePage,
              rules = _this$state2.rules,
              successPageSettings = _this$state2.successPageSettings;
          IncrementalDOM.elementOpen("span");
          iDOMHelpers.renderArbitrary((children || []).map(function (child) {
            return _objectSpread(_objectSpread({}, child), {}, {
              props: _objectSpread(_objectSpread(_objectSpread({}, child.props), _this2.otherProps()), {}, {
                activePage: activePage,
                allowSuccessPage: allowSuccessPage,
                defaultLanguageId: defaultLanguageId,
                editingLanguageId: editingLanguageId,
                fieldActions: fieldActions,
                focusedField: _this2.getFocusedField(),
                pages: _this2.getPages(),
                paginationMode: _this2.getPaginationMode(),
                rules: rules,
                spritemap: spritemap,
                successPageSettings: successPageSettings
              })
            });
          }));
          return IncrementalDOM.elementClose("span");
        }
      }, {
        key: "_handleDeleteFieldModalButtonClicked",
        value: function _handleDeleteFieldModalButtonClicked(event) {
          this.setState((0, _fieldDeletedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_fieldActionsValueFn",
        value: function _fieldActionsValueFn() {
          var _this3 = this;

          return [{
            action: function action(_ref) {
              var activePage = _ref.activePage,
                  fieldName = _ref.fieldName;
              return _this3.dispatch('fieldDuplicated', {
                activePage: activePage,
                fieldName: fieldName
              });
            },
            label: Liferay.Language.get('duplicate')
          }, {
            action: function action(_ref2) {
              var activePage = _ref2.activePage,
                  fieldName = _ref2.fieldName;

              _this3.dispatch('fieldDeleted', {
                activePage: activePage,
                fieldName: fieldName
              });
            },
            label: Liferay.Language.get('delete')
          }];
        }
      }, {
        key: "_fieldNameGeneratorValueFn",
        value: function _fieldNameGeneratorValueFn() {
          var _this4 = this;

          return function (desiredName, currentName) {
            var blacklist = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
            var pages = _this4.state.pages;
            var generateFieldNameUsingFieldLabel = _this4.props.generateFieldNameUsingFieldLabel;
            return (0, _fields.generateFieldName)(pages, desiredName, currentName, blacklist, generateFieldNameUsingFieldLabel);
          };
        }
      }, {
        key: "_handleActivePageUpdated",
        value: function _handleActivePageUpdated(activePage) {
          this.setState({
            activePage: activePage
          });
        }
      }, {
        key: "_handleColumnResized",
        value: function _handleColumnResized(_ref3) {
          var column = _ref3.column,
              container = _ref3.container,
              direction = _ref3.direction,
              source = _ref3.source;
          var props = this.props,
              state = this.state;
          this.setState((0, _columnResizedHandler.default)(props, state, source, container, column, direction));
        }
      }, {
        key: "_handleElementSetAdded",
        value: function _handleElementSetAdded(event) {
          this.setState((0, _elementSetAddedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleFieldAdded",
        value: function _handleFieldAdded(event) {
          this.setState((0, _fieldAddedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleFieldHovered",
        value: function _handleFieldHovered(fieldHovered) {
          this.setState({
            fieldHovered: fieldHovered
          });
        }
      }, {
        key: "_handleFieldBlurred",
        value: function _handleFieldBlurred(event) {
          this.setState((0, _fieldBlurredHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleFieldChangesCanceled",
        value: function _handleFieldChangesCanceled() {
          var _this5 = this;

          var _this$state3 = this.state,
              activePage = _this$state3.activePage,
              focusedField = _this$state3.focusedField,
              pages = _this$state3.pages,
              previousFocusedField = _this$state3.previousFocusedField;
          var settingsContext = previousFocusedField.settingsContext;
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
          visitor.mapFields(function (_ref4) {
            var fieldName = _ref4.fieldName,
                value = _ref4.value;

            _this5._handleFieldEdited({
              propertyName: fieldName,
              propertyValue: value
            });
          });
          visitor.setPages(pages);
          this.setState({
            activePage: activePage,
            focusedField: previousFocusedField,
            pages: visitor.mapFields(function (field) {
              if (field.fieldName === focusedField.fieldName) {
                return _objectSpread(_objectSpread({}, field), {}, {
                  settingsContext: settingsContext
                });
              }

              return field;
            })
          });
        }
      }, {
        key: "_handleFieldClicked",
        value: function _handleFieldClicked(event) {
          this.setState((0, _fieldClickedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleFieldDeleted",
        value: function _handleFieldDeleted(event) {
          var _this6 = this;

          var rules = this.state.rules;

          if (rules && _RulesSupport.default.findRuleByFieldName(event.fieldName, null, rules)) {
            (0, _frontendJsWeb.openModal)({
              bodyHTML: Liferay.Language.get('a-rule-is-applied-to-this-field'),
              buttons: [{
                displayType: 'secondary',
                label: Liferay.Language.get('cancel'),
                type: 'cancel'
              }, {
                displayType: 'danger',
                label: Liferay.Language.get('confirm'),
                onClick: function onClick() {
                  _this6._handleDeleteFieldModalButtonClicked(event);
                },
                type: 'cancel'
              }],
              id: 'ddm-delete-field-with-rule-modal',
              size: 'md',
              title: Liferay.Language.get('delete-field-with-rule-applied')
            });
          } else {
            this.setState((0, _fieldDeletedHandler.default)(this.props, this.state, event));
          }
        }
      }, {
        key: "_handleFieldDuplicated",
        value: function _handleFieldDuplicated(event) {
          this.setState((0, _fieldDuplicatedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleFieldEdited",
        value: function _handleFieldEdited(properties) {
          this.setState((0, _fieldEditedHandler.default)(this.props, this.state, properties));
        }
      }, {
        key: "_handleFieldEditedProperties",
        value: function _handleFieldEditedProperties(properties) {
          this.setState((0, _fieldEditedPropertiesHandler.default)(this.props, this.state, properties));
        }
      }, {
        key: "_handleFieldMoved",
        value: function _handleFieldMoved(event) {
          this.setState((0, _fieldMovedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleFieldSetAdded",
        value: function _handleFieldSetAdded(event) {
          this.setState((0, _fieldSetAddedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleFocusedFieldEvaluationEnded",
        value: function _handleFocusedFieldEvaluationEnded(_ref5) {
          var changedEditingLanguage = _ref5.changedEditingLanguage,
              changedFieldType = _ref5.changedFieldType,
              instanceId = _ref5.instanceId,
              settingsContext = _ref5.settingsContext;
          this.setState((0, _focusedFieldEvaluationEndedHandler.default)(this.props, this.state, changedEditingLanguage, changedFieldType, instanceId, settingsContext));
        }
      }, {
        key: "_handleLanguageIdDeleted",
        value: function _handleLanguageIdDeleted(_ref6) {
          var locale = _ref6.locale;
          var _this$state4 = this.state,
              focusedField = _this$state4.focusedField,
              pages = _this$state4.pages;
          this.setState((0, _languageIdDeletedHandler.default)(focusedField, pages, locale));
        }
      }, {
        key: "_handlePageAdded",
        value: function _handlePageAdded(_ref7) {
          var pageIndex = _ref7.pageIndex;
          var pages = this.state.pages;
          pages.splice(pageIndex + 1, 0, this.createNewPage());
          this.setState({
            activePage: pageIndex + 1,
            pages: pages
          });
        }
      }, {
        key: "_handlePageDeleted",
        value: function _handlePageDeleted(pageIndex) {
          var pages = this.state.pages;
          this.setState({
            activePage: Math.max(0, pageIndex - 1),
            pages: pages.filter(function (page, index) {
              return index != pageIndex;
            })
          });
        }
      }, {
        key: "_handlePageReset",
        value: function _handlePageReset(_ref8) {
          var pageIndex = _ref8.pageIndex;
          var pages = this.state.pages;
          pages.splice(pageIndex, 1, this.createNewPage());
          this.setState({
            pages: pages
          });
        }
      }, {
        key: "_handlePagesSwapped",
        value: function _handlePagesSwapped(_ref9) {
          var firstIndex = _ref9.firstIndex,
              secondIndex = _ref9.secondIndex;
          var pages = this.state.pages;
          var _ref10 = [pages[firstIndex], pages[secondIndex]],
              firstPage = _ref10[0],
              secondPage = _ref10[1];
          this.setState({
            pages: pages.map(function (page, index) {
              if (index === firstIndex) {
                return secondPage;
              } else if (index === secondIndex) {
                return firstPage;
              }

              return page;
            })
          });
        }
      }, {
        key: "_handlePagesUpdated",
        value: function _handlePagesUpdated(pages) {
          this.setState({
            pages: _toConsumableArray(pages)
          });
        }
      }, {
        key: "_handlePaginationModeUpdated",
        value: function _handlePaginationModeUpdated() {
          var paginationMode = this.state.paginationMode;
          var newMode = 'paginated';

          if (paginationMode === newMode) {
            newMode = 'wizard';
          }

          this.setState({
            paginationMode: newMode
          });
        }
      }, {
        key: "_handlePaginationNextClicked",
        value: function _handlePaginationNextClicked() {
          var _this$state5 = this.state,
              activePage = _this$state5.activePage,
              pages = _this$state5.pages;
          var pageIndex = Math.min(activePage + 1, pages.length - 1);
          this.dispatch('activePageUpdated', pageIndex);
        }
      }, {
        key: "_handlePaginationPreviousClicked",
        value: function _handlePaginationPreviousClicked() {
          var activePage = this.state.activePage;
          var pageIndex = Math.max(activePage - 1, 0);
          this.dispatch('activePageUpdated', pageIndex);
        }
      }, {
        key: "_handleRuleAdded",
        value: function _handleRuleAdded(rule) {
          this.setState({
            rules: [].concat(_toConsumableArray(this.state.rules), [rule])
          });
          this.emit('rulesModified');
        }
      }, {
        key: "_handleRuleDeleted",
        value: function _handleRuleDeleted(_ref11) {
          var ruleId = _ref11.ruleId;
          var rules = this.state.rules;
          this.setState({
            rules: rules.filter(function (rule, index) {
              return index !== ruleId;
            })
          });
          this.emit('rulesModified');
        }
      }, {
        key: "_handleRuleValidatorChanged",
        value: function _handleRuleValidatorChanged(invalidRule) {
          this.emit('ruleValidatorChanged', invalidRule);
        }
      }, {
        key: "_handleRuleSaved",
        value: function _handleRuleSaved(event) {
          var actions = event.actions,
              conditions = event.conditions,
              ruleEditedIndex = event.ruleEditedIndex;
          var logicalOperator = event['logical-operator'];
          var rules = this.state.rules;

          rules.splice(ruleEditedIndex, 1, {
            actions: actions,
            conditions: conditions,
            'logical-operator': logicalOperator
          });
          this.setState({
            rules: rules
          });
          this.emit('rulesModified');
        }
      }, {
        key: "_handleSectionAdded",
        value: function _handleSectionAdded(event) {
          this.setState((0, _sectionAddedHandler.default)(this.props, this.state, event));
        }
      }, {
        key: "_handleSidebarFieldBlurred",
        value: function _handleSidebarFieldBlurred() {
          this.setState({
            focusedField: {}
          });
        }
      }, {
        key: "_handleSuccessPageChanged",
        value: function _handleSuccessPageChanged(successPageSettings) {
          this.setState({
            successPageSettings: successPageSettings
          });
        }
      }, {
        key: "_pagesValueFn",
        value: function _pagesValueFn() {
          var initialPages = this.props.initialPages;
          return initialPages;
        }
      }, {
        key: "_paginationModeValueFn",
        value: function _paginationModeValueFn() {
          return this.props.initialPaginationMode;
        }
      }, {
        key: "_rulesValueFn",
        value: function _rulesValueFn() {
          var rules = this.props.rules;
          return rules;
        }
      }, {
        key: "_setEvents",
        value: function _setEvents(value) {
          return _objectSpread(_objectSpread({}, this.getEvents()), value);
        }
      }, {
        key: "_setInitialPages",
        value: function _setInitialPages(initialPages) {
          var _this7 = this;

          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(initialPages);
          return visitor.mapFields(function (field) {
            var settingsContext = field.settingsContext;
            return _objectSpread(_objectSpread({}, field), {}, {
              localizedValue: {},
              readOnly: true,
              settingsContext: _objectSpread({}, _this7._setInitialSettingsContext(settingsContext)),
              value: undefined,
              visible: true
            });
          }, true, true);
        }
      }, {
        key: "_setInitialSettingsContext",
        value: function _setInitialSettingsContext(settingsContext) {
          var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);
          return _objectSpread(_objectSpread({}, settingsContext), {}, {
            pages: visitor.mapFields(function (field) {
              if (field.type === 'options') {
                var getOptions = function getOptions(languageId, field) {
                  return field.value[languageId].map(function (option) {
                    return _objectSpread(_objectSpread({}, option), {}, {
                      edited: true
                    });
                  });
                };

                Object.keys(field.value).forEach(function (languageId) {
                  field = _objectSpread(_objectSpread({}, field), {}, {
                    value: _objectSpread(_objectSpread({}, field.value), {}, _defineProperty({}, languageId, getOptions(languageId, field)))
                  });
                });
              }

              return field;
            })
          });
        }
      }, {
        key: "_setPages",
        value: function _setPages(pages) {
          return pages.filter(function (_ref12) {
            var contentRenderer = _ref12.contentRenderer;
            return contentRenderer !== 'success';
          });
        }
      }, {
        key: "_successPageSettingsValueFn",
        value: function _successPageSettingsValueFn() {
          var _this$props5 = this.props,
              defaultLanguageId = _this$props5.defaultLanguageId,
              initialSuccessPageSettings = _this$props5.initialSuccessPageSettings;

          if (!initialSuccessPageSettings || Object.keys(initialSuccessPageSettings.body).length > 1) {
            return initialSuccessPageSettings;
          }

          var body = initialSuccessPageSettings.body,
              title = initialSuccessPageSettings.title,
              otherProps = _objectWithoutProperties(initialSuccessPageSettings, ["body", "title"]);

          return _objectSpread(_objectSpread({}, otherProps), {}, {
            body: _objectSpread(_objectSpread({}, body), {}, _defineProperty({}, defaultLanguageId, body[defaultLanguageId] === '' ? Liferay.Language.get('your-information-was-successfully-received-thank-you-for-filling-out-the-form') : body[defaultLanguageId])),
            title: _objectSpread(_objectSpread({}, title), {}, _defineProperty({}, defaultLanguageId, title[defaultLanguageId] === '' ? Liferay.Language.get('thank-you') : title[defaultLanguageId]))
          });
        }
      }]);

      return LayoutProvider;
    }(_metalJsx.default);

    LayoutProvider.PROPS = {
      /**
       * @instance
       * @memberof LayoutProvider
       * @type {boolean}
       */
      allowMultiplePages: _metalState.Config.bool().value(true),

      /**
       * @instance
       * @memberof LayoutProvider
       * @type {boolean}
       */
      allowSuccessPage: _metalState.Config.bool().value(true),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?string}
       */
      defaultLanguageId: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?string}
       */
      editingLanguageId: _metalState.Config.string(),

      /**
       * @default {}
       * @instance
       * @memberof LayoutProvider
       * @type {?object}
       */
      events: _metalState.Config.setter('_setEvents').value({}),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?string}
       */
      fieldActions: _metalState.Config.array().valueFn('_fieldActionsValueFn'),

      /**
       * @default _fieldNameGeneratorValueFn
       * @instance
       * @memberof LayoutProvider
       * @type {?function}
       */
      fieldNameGenerator: _metalState.Config.func().valueFn('_fieldNameGeneratorValueFn'),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?string}
       */
      fieldSetDefinitionURL: _metalState.Config.string(),

      /**
       * @default []
       * @instance
       * @memberof LayoutProvider
       * @type {?(array|undefined)}
       */
      fieldSets: _metalState.Config.array().value([]),

      /**
       * @default false
       * @instance
       * @memberof LayoutProvider
       * @type {?bool}
       */
      generateFieldNameUsingFieldLabel: _metalState.Config.bool().value(false),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?(array|undefined)}
       */
      initialPages: _metalState.Config.arrayOf(_config.pageStructure).setter('_setInitialPages').value([]),

      /**
       * @default 'wizard'
       * @instance
       * @memberof LayoutProvider
       * @type {?string}
       */
      initialPaginationMode: _metalState.Config.string().value('wizard'),

      /**
       * @instance
       * @memberof LayoutProvider
       * @type {object}
       */
      initialSuccessPageSettings: _metalState.Config.shapeOf({
        body: _metalState.Config.object(),
        enabled: _metalState.Config.bool(),
        title: _metalState.Config.object()
      }),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?(array|undefined)}
       */
      rules: _metalState.Config.arrayOf(_config.ruleStructure),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?(array|undefined)}
       */
      spritemap: _metalState.Config.string(),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?string}
       */
      view: _metalState.Config.string()
    };
    LayoutProvider.STATE = {
      /**
       * @instance
       * @memberof FormPage
       * @type {?number}
       */
      activePage: _metalState.Config.number().value(0),

      /**
       * @default {}
       * @instance
       * @memberof LayoutProvider
       * @type {?object}
       */
      fieldHovered: _metalState.Config.object().value({}),

      /**
       * @default {}
       * @instance
       * @memberof LayoutProvider
       * @type {?object}
       */
      focusedField: _metalState.Config.shapeOf({
        columnIndex: _metalState.Config.oneOfType([_metalState.Config.bool().value(false), _metalState.Config.number()]).required(),
        pageIndex: _metalState.Config.number().required(),
        rowIndex: _metalState.Config.number().required(),
        type: _metalState.Config.string().required()
      }).value({}),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?array}
       */
      pages: _metalState.Config.arrayOf(_config.pageStructure).setter('_setPages').valueFn('_pagesValueFn'),

      /**
       * @instance
       * @memberof LayoutProvider
       * @type {string}
       */
      paginationMode: _metalState.Config.string().valueFn('_paginationModeValueFn'),

      /**
       * @default {}
       * @instance
       * @memberof LayoutProvider
       * @type {?object}
       */
      previousFocusedField: _metalState.Config.shapeOf({
        columnIndex: _metalState.Config.oneOfType([_metalState.Config.bool().value(false), _metalState.Config.number()]).required(),
        pageIndex: _metalState.Config.number().required(),
        rowIndex: _metalState.Config.number().required(),
        type: _metalState.Config.string().required()
      }).value({}),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?(array|undefined)}
       */
      rules: _metalState.Config.arrayOf(_config.ruleStructure).valueFn('_rulesValueFn'),

      /**
       * @default undefined
       * @instance
       * @memberof LayoutProvider
       * @type {?(object|undefined)}
       */
      successPageSettings: _metalState.Config.object().valueFn('_successPageSettingsValueFn')
    };
    var _default = LayoutProvider;
    exports.default = _default;
    //# sourceMappingURL=LayoutProvider.es.js.map
  }
});
//# sourceMappingURL=LayoutProvider.es.js.map