/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.model.Expression;
import com.liferay.dynamic.data.mapping.expression.model.ExpressionVisitor;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor.ActionExpressionVisitor;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.visitor.ConditionExpressionVisitor;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRule;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleCondition;
import com.liferay.dynamic.data.mapping.spi.converter.serializer.SPIDDMFormRuleSerializerContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SPIDDMFormRuleConverter.class})
public class DDMFormRuleConverterImpl
implements SPIDDMFormRuleConverter {
    @Reference
    protected DDMExpressionFactory ddmExpressionFactory;
    private static final String _COMPARISON_EXPRESSION_FORMAT = "%s %s %s";
    private static final String _FUNCTION_CALL_BINARY_EXPRESSION_FORMAT = "%s(%s, %s)";
    private static final String _FUNCTION_CALL_UNARY_EXPRESSION_FORMAT = "%s(%s)";
    private static final String _NOT_EXPRESSION_FORMAT = "not(%s)";
    private static final Map<String, String> _operatorFunctionNameMap = HashMapBuilder.put((Object)"belongs-to", (Object)"belongsTo").put((Object)"contains", (Object)"contains").put((Object)"equals-to", (Object)"equals").put((Object)"is-empty", (Object)"isEmpty").put((Object)"not-contains", (Object)"contains").put((Object)"not-equals-to", (Object)"equals").put((Object)"not-is-empty", (Object)"isEmpty").build();
    private static final Map<String, String> _operatorMap = HashMapBuilder.put((Object)"greater-than", (Object)">").put((Object)"greater-than-equals", (Object)">=").put((Object)"less-than", (Object)"<").put((Object)"less-than-equals", (Object)"<=").build();

    public List<SPIDDMFormRule> convert(List<DDMFormRule> ddmFormRules) {
        ArrayList<SPIDDMFormRule> spiDDMFormRules = new ArrayList<SPIDDMFormRule>();
        for (DDMFormRule ddmFormRule : ddmFormRules) {
            spiDDMFormRules.add(this.convertRule(ddmFormRule));
        }
        return spiDDMFormRules;
    }

    public List<DDMFormRule> convert(List<SPIDDMFormRule> spiDDMFormRules, SPIDDMFormRuleSerializerContext spiDDMFormRuleSerializerContext) {
        Stream spiDDMFormRuleStream = spiDDMFormRules.stream();
        Stream<DDMFormRule> ddmFormRuleStream = spiDDMFormRuleStream.map(formRule -> this.convertRule((SPIDDMFormRule)formRule, spiDDMFormRuleSerializerContext));
        return ddmFormRuleStream.collect(Collectors.toList());
    }

    protected SPIDDMFormRuleAction convertAction(String actionExpressionString) {
        Expression actionExpression = this.createExpression(actionExpressionString);
        ActionExpressionVisitor actionExpressionVisitor = new ActionExpressionVisitor();
        return (SPIDDMFormRuleAction)actionExpression.accept((ExpressionVisitor)actionExpressionVisitor);
    }

    protected String convertCondition(SPIDDMFormRuleCondition spiDDMFormRuleCondition) {
        String operator = spiDDMFormRuleCondition.getOperator();
        String functionName = _operatorFunctionNameMap.get(operator);
        List operands = spiDDMFormRuleCondition.getOperands();
        if (functionName == null) {
            if (operands.size() < 2) {
                return "";
            }
            return String.format(_COMPARISON_EXPRESSION_FORMAT, this.convertOperand((SPIDDMFormRuleCondition.Operand)operands.get(0)), _operatorMap.get(operator), this.convertOperand((SPIDDMFormRuleCondition.Operand)operands.get(1)));
        }
        String condition = this.createCondition(functionName, operands);
        if (operator.startsWith("not")) {
            return String.format(_NOT_EXPRESSION_FORMAT, condition);
        }
        return condition;
    }

    protected String convertConditions(String logicalOperator, List<SPIDDMFormRuleCondition> spiDDMFormRuleConditions) {
        if (spiDDMFormRuleConditions.size() == 1) {
            return this.convertCondition(spiDDMFormRuleConditions.get(0));
        }
        StringBundler sb = new StringBundler(spiDDMFormRuleConditions.size() * 4);
        for (SPIDDMFormRuleCondition spiDDMFormRuleCondition : spiDDMFormRuleConditions) {
            sb.append(this.convertCondition(spiDDMFormRuleCondition));
            sb.append(" ");
            sb.append(logicalOperator);
            sb.append(" ");
        }
        sb.setIndex(sb.index() - 3);
        return sb.toString();
    }

    protected String convertOperand(SPIDDMFormRuleCondition.Operand operand) {
        if (Objects.equals("field", operand.getType())) {
            return String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, "getValue", StringUtil.quote((String)operand.getValue()));
        }
        String value = operand.getValue();
        if (this.isNumericConstant(operand.getType())) {
            return value;
        }
        if (Objects.equals("string", operand.getType())) {
            return StringUtil.quote((String)value);
        }
        String[] values = StringUtil.split((String)value);
        UnaryOperator quoteOperation = StringUtil::quote;
        UnaryOperator trimOperation = StringUtil::trim;
        return Stream.of(values).map(trimOperation.andThen(quoteOperation)).collect(this.getCollector(operand.getType()));
    }

    protected String convertOperands(List<SPIDDMFormRuleCondition.Operand> operands) {
        StringBundler sb = new StringBundler(operands.size());
        boolean hasNestedFunction = this._hasNestedFunction(operands);
        for (int i = 0; i < operands.size(); ++i) {
            SPIDDMFormRuleCondition.Operand operand = operands.get(i);
            if (hasNestedFunction) {
                sb.append(operand.getValue());
            } else if (i > 0 && Objects.equals("option", operand.getType())) {
                SPIDDMFormRuleCondition.Operand previousOperand = operands.get(i - 1);
                sb.append(String.format(_FUNCTION_CALL_BINARY_EXPRESSION_FORMAT, "getOptionLabel", StringUtil.quote((String)previousOperand.getValue()), StringUtil.quote((String)operand.getValue())));
            } else {
                sb.append(this.convertOperand(operand));
            }
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    protected SPIDDMFormRule convertRule(DDMFormRule ddmFormRule) {
        SPIDDMFormRule spiDDMFormRule = new SPIDDMFormRule();
        spiDDMFormRule.setName(ddmFormRule.getName());
        this.setSPIDDMFormRuleConditions(spiDDMFormRule, ddmFormRule.getCondition());
        this.setSPIDDMFormRuleActions(spiDDMFormRule, ddmFormRule.getActions());
        return spiDDMFormRule;
    }

    protected DDMFormRule convertRule(SPIDDMFormRule spiDDMFormRule, SPIDDMFormRuleSerializerContext spiDDMFormRuleSerializerContext) {
        String condition = this.convertConditions(spiDDMFormRule.getLogicalOperator(), spiDDMFormRule.getSPIDDMFormRuleConditions());
        ArrayList<String> actions = new ArrayList<String>();
        for (SPIDDMFormRuleAction spiDDMFormRuleAction : spiDDMFormRule.getSPIDDMFormRuleActions()) {
            actions.add(spiDDMFormRuleAction.serialize(spiDDMFormRuleSerializerContext));
        }
        return new DDMFormRule(actions, condition, spiDDMFormRule.getName());
    }

    protected String createCondition(String functionName, List<SPIDDMFormRuleCondition.Operand> operands) {
        if (Objects.equals(functionName, "belongsTo")) {
            operands.removeIf(operand -> StringUtil.equals((String)operand.getType(), (String)"user"));
        }
        return String.format(_FUNCTION_CALL_UNARY_EXPRESSION_FORMAT, functionName, this.convertOperands(operands));
    }

    protected Expression createExpression(String expressionString) {
        try {
            CreateExpressionRequest createExpressionRequest = CreateExpressionRequest.Builder.newBuilder((String)expressionString).build();
            DDMExpression ddmExpression = this.ddmExpressionFactory.createExpression(createExpressionRequest);
            return ddmExpression.getModel();
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new IllegalStateException(String.format("Unable to parse expression \"%s\"", expressionString), ddmExpressionException);
        }
    }

    protected Collector<CharSequence, ?, String> getCollector(String operandType) {
        if (operandType.equals("list")) {
            return Collectors.joining(", ", "[", "]");
        }
        return Collectors.joining(", ");
    }

    protected boolean isNumericConstant(String operandType) {
        return operandType.equals("integer") || operandType.equals("double");
    }

    protected void setSPIDDMFormRuleActions(SPIDDMFormRule spiDDMFormRule, List<String> actions) {
        ArrayList<SPIDDMFormRuleAction> spiDDMFormRuleActions = new ArrayList<SPIDDMFormRuleAction>();
        for (String action : actions) {
            spiDDMFormRuleActions.add(this.convertAction(action));
        }
        spiDDMFormRule.setSPIDDMFormRuleActions(spiDDMFormRuleActions);
    }

    protected void setSPIDDMFormRuleConditions(SPIDDMFormRule spiDDMFormRule, String conditionExpressionString) {
        Expression conditionExpression = this.createExpression(conditionExpressionString);
        ConditionExpressionVisitor conditionExpressionVisitor = new ConditionExpressionVisitor();
        conditionExpression.accept((ExpressionVisitor)conditionExpressionVisitor);
        spiDDMFormRule.setSPIDDMFormRuleConditions(conditionExpressionVisitor.getSPIDDMFormRuleConditions());
        spiDDMFormRule.setLogicalOperator(conditionExpressionVisitor.getLogicalOperator());
    }

    private boolean _hasNestedFunction(List<SPIDDMFormRuleCondition.Operand> operands) {
        Stream operandStream = operands.stream();
        return operandStream.anyMatch(operand -> this._isNestedFunction(operand.getValue()));
    }

    private boolean _isNestedFunction(String operandValue) {
        return operandValue.matches("[aA-zZ0-9]+[(].*[aA-zZ0-9]+[(].*[)].*[)]");
    }
}

