/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {FormSupport, PagesVisitor} from 'dynamic-data-mapping-form-renderer';

import {generateFieldName} from '../util/fields.es';

const handleElementSetAdded = (props, state, event) => {
	const {fieldSetPages, indexes} = event;
	const {pages} = state;
	const {pageIndex, rowIndex} = indexes;

	const visitor = new PagesVisitor(fieldSetPages);

	const newFieldsetPages = visitor.mapFields((field) => {
		const name = generateFieldName(pages, field.fieldName);

		const settingsContextVisitor = new PagesVisitor(
			field.settingsContext.pages
		);

		return {
			...field,
			fieldName: name,
			settingsContext: {
				...field.settingsContext,
				pages: settingsContextVisitor.mapFields(
					(settingsContextField) => {
						if (settingsContextField.fieldName === 'name') {
							settingsContextField = {
								...settingsContextField,
								value: name,
							};
						}

						return settingsContextField;
					}
				),
			},
		};
	});

	const rows = newFieldsetPages[0].rows;

	for (let i = rows.length - 1; i >= 0; i--) {
		pages[pageIndex].rows.splice(rowIndex, 0, rows[i]);
	}

	return {
		pages: pages.map((page, index) => {
			if (index === pageIndex) {
				return {
					...page,
					rows: FormSupport.removeEmptyRows(pages, index),
				};
			}

			return page;
		}),
	};
};

export default handleElementSetAdded;
