/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {getField} from '../../../util/fieldSupport.es';
import {updateRulesReferences} from '../util/rules.es';
import {updateField} from '../util/settingsContext.es';
import {updatePages} from './fieldEditedHandler.es';

const updateState = (props, state, properties) => {
	const {activePage, focusedField, pages, rules} = state;
	const {fieldName: previousFocusedFieldName} = focusedField;
	let newFocusedField;

	const {defaultLanguageId} = props;

	if (properties.length === 1) {
		const [{name, value}] = properties;
		newFocusedField = updateField(props, focusedField, name, value);
	}
	else {
		newFocusedField = properties.reduce(
			(initialField, {name, value}, index) => {
				let useField = initialField;
				if (index === 1) {
					if (initialField.name === 'nestedFields') {
						initialField.value = initialField.value.map(
							(nestedField) => {
								return updateField(
									props,
									nestedField,
									'label',
									nestedField.label[defaultLanguageId]
								);
							}
						);
					}

					useField = updateField(
						props,
						focusedField,
						initialField.name,
						initialField.value
					);
				}

				return updateField(props, useField, name, value);
			}
		);
	}

	const newPages = updatePages(
		props,
		pages,
		previousFocusedFieldName,
		newFocusedField
	);

	return {
		activePage,
		focusedField: newFocusedField,
		pages: newPages,
		rules: updateRulesReferences(
			rules || [],
			focusedField,
			newFocusedField
		),
	};
};

export default (props, state, event) => {
	const {fieldName, properties} = event;

	if (!Array.isArray(properties) || !properties.length) {
		return;
	}

	properties.filter(({name, value}) => name !== 'name' || value !== '');

	state = {
		...state,
		...(fieldName && {focusedField: getField(state.pages, fieldName)}),
	};

	return updateState(props, state, properties);
};
