Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.37/js/components/LayoutProvider/handlers/sectionAddedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/constants.es', '../../../util/fieldSupport.es', '../util/fieldset.es', '../util/settingsContext.es', './fieldAddedHandler.es', './fieldDeletedHandler.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _constants = require("../../../util/constants.es");

  var _fieldSupport = require("../../../util/fieldSupport.es");

  var _fieldset = require("../util/fieldset.es");

  var _settingsContext = require("../util/settingsContext.es");

  var _fieldAddedHandler = _interopRequireDefault(require("./fieldAddedHandler.es"));

  var _fieldDeletedHandler = _interopRequireDefault(require("./fieldDeletedHandler.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var addNestedField = function addNestedField(_ref) {
    var field = _ref.field,
        indexes = _ref.indexes,
        nestedField = _ref.nestedField,
        props = _ref.props;

    var layout = _dynamicDataMappingFormRenderer.FormSupport.addFieldToColumn([{
      rows: field.rows
    }], indexes.pageIndex, indexes.rowIndex, indexes.columnIndex, nestedField.fieldName);

    var nestedFields = [].concat(_toConsumableArray(field.nestedFields), [nestedField]);
    field = (0, _settingsContext.updateField)(props, field, 'nestedFields', nestedFields);
    var rows = layout[indexes.pageIndex].rows;
    field = (0, _settingsContext.updateField)(props, field, 'rows', rows);
    return _objectSpread({}, field, {
      nestedFields: nestedFields,
      rows: rows
    });
  };

  var handleSectionAdded = function handleSectionAdded(props, state, event) {
    var data = event.data,
        indexes = event.indexes;
    var fieldName = data.fieldName,
        parentFieldName = data.parentFieldName;
    var pages = state.pages;
    var newField = event.newField || (0, _fieldSupport.createField)(props, event);

    var existingField = _dynamicDataMappingFormRenderer.FormSupport.findFieldByFieldName(pages, fieldName);

    var fieldSetField = (0, _fieldset.createFieldSet)(props, event, [existingField, newField]);
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
    var newPages;

    if (parentFieldName) {
      newPages = visitor.mapFields(function (field) {
        if (field.fieldName === parentFieldName) {
          var updatedParentField = _dynamicDataMappingFormRenderer.FormSupport.findFieldByFieldName((0, _fieldDeletedHandler["default"])(props, state, {
            fieldName: fieldName
          }).pages, parentFieldName);

          return addNestedField({
            field: updatedParentField,
            indexes: indexes,
            nestedField: fieldSetField,
            props: props
          });
        }

        return field;
      }, false, true);
    } else if (existingField.type === _constants.FIELD_TYPE_FIELDSET) {
      newPages = (0, _fieldAddedHandler["default"])(props, state, _objectSpread({}, event, {
        data: _objectSpread({}, event.data, {
          parentFieldName: existingField.fieldName
        })
      })).pages;
    } else {
      newPages = visitor.mapFields(function (field) {
        if (field.fieldName === fieldName) {
          return fieldSetField;
        }

        return field;
      });
    }

    return {
      focusedField: _objectSpread({}, newField),
      pages: newPages,
      previousFocusedField: fieldSetField
    };
  };

  var _default = handleSectionAdded;
  exports["default"] = _default;
  //# sourceMappingURL=sectionAddedHandler.es.js.map
});
//# sourceMappingURL=sectionAddedHandler.es.js.map