/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'dynamic-data-mapping-form-renderer';

import {createFieldSet} from '../util/fieldset.es';
import {updateField} from '../util/settingsContext.es';
import {addField} from './fieldAddedHandler.es';

const handleFieldSetAdded = (props, state, event) => {
	const {
		fieldSet,
		indexes,
		parentFieldName,
		properties,
		rows,
		useFieldName,
	} = event;
	const {pages} = state;
	const visitor = new PagesVisitor(fieldSet.pages);
	const nestedFields = [];

	visitor.mapFields((nestedField) => {
		nestedFields.push(nestedField);
	});

	let fieldSetField = createFieldSet(
		props,
		{skipFieldNameGeneration: false, useFieldName},
		nestedFields
	);

	if (properties) {
		Object.keys(properties).forEach((key) => {
			fieldSetField = updateField(
				props,
				fieldSetField,
				key,
				properties[key]
			);
		});
	}

	if (fieldSet.id) {
		fieldSetField = updateField(
			props,
			fieldSetField,
			'ddmStructureId',
			fieldSet.id
		);
	}

	if (rows && rows.length) {
		fieldSetField = updateField(props, fieldSetField, 'rows', rows);
	}

	return addField(props, {
		indexes,
		newField: updateField(props, fieldSetField, 'label', fieldSet.title),
		pages,
		parentFieldName,
	});
};

export default handleFieldSetAdded;
