/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'dynamic-data-mapping-form-renderer/js/util/visitors.es';

import {getField} from '../../../util/fieldSupport.es';
import {updateRulesReferences} from '../util/rules.es';
import {
	updateField,
	updateSettingsContextProperty,
} from '../util/settingsContext.es';

export const updatePages = (props, pages, previousFieldName, newField) => {
	let parentFieldName;
	const visitor = new PagesVisitor(pages);

	const {fieldName: newFieldName} = newField;

	let newPages = visitor.mapFields(
		(field, fieldIndex, columnIndex, rowIndex, pageIndex, parentField) => {
			if (field.fieldName === previousFieldName) {
				if (parentField) {
					parentFieldName = parentField.fieldName;
				}

				return newField;
			}

			return field;
		},
		true,
		true
	);

	if (parentFieldName && previousFieldName !== newFieldName) {
		visitor.setPages(newPages);

		newPages = visitor.mapFields(
			(field) => {
				if (parentFieldName === field.fieldName) {
					const visitor = new PagesVisitor([
						{
							rows: field.rows || [],
						},
					]);
					const layout = visitor.mapColumns((column) => {
						return {
							...column,
							fields: column.fields.map((fieldName) => {
								if (fieldName === previousFieldName) {
									return newFieldName;
								}

								return fieldName;
							}),
						};
					});
					const {rows} = layout[0];

					return {
						...field,
						rows,
						settingsContext: updateSettingsContextProperty(
							props.editingLanguageId,
							field.settingsContext,
							'rows',
							rows
						),
					};
				}

				return field;
			},
			true,
			true
		);
	}

	return newPages;
};

export const updateState = (props, state, propertyName, propertyValue) => {
	const {activePage, focusedField, pages, rules} = state;
	const {fieldName: previousFocusedFieldName} = focusedField;
	const newFocusedField = updateField(
		props,
		focusedField,
		propertyName,
		propertyValue
	);

	const newPages = updatePages(
		props,
		pages,
		previousFocusedFieldName,
		newFocusedField
	);

	return {
		activePage,
		focusedField: newFocusedField,
		pages: newPages,
		rules: updateRulesReferences(
			rules || [],
			focusedField,
			newFocusedField
		),
	};
};

export const handleFieldEdited = (props, state, event) => {
	const {fieldName, propertyName, propertyValue} = event;
	let newState = {};

	if (propertyName !== 'name' || propertyValue !== '') {
		state = {
			...state,
			...(fieldName && {focusedField: getField(state.pages, fieldName)}),
		};

		newState = updateState(props, state, propertyName, propertyValue);
	}

	return newState;
};

export default handleFieldEdited;
