Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.31/js/components/LayoutProvider/handlers/fieldClickedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/fieldSupport.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _fieldSupport = require("../../../util/fieldSupport.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldClicked = function handleFieldClicked(props, state, event) {
    var fieldName = event.fieldName;
    var activePage = event.activePage;
    var pages = state.pages;
    var parentFieldSet = (0, _fieldSupport.getParentFieldSet)(pages, fieldName);

    if (parentFieldSet) {
      fieldName = parentFieldSet.fieldName;
    }

    var fieldProperties = _dynamicDataMappingFormRenderer.FormSupport.findFieldByFieldName(pages, fieldName);

    var settingsContext = fieldProperties.settingsContext;
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(settingsContext.pages);

    var focusedField = _objectSpread({}, fieldProperties, {
      settingsContext: _objectSpread({}, settingsContext, {
        currentPage: activePage,
        pages: visitor.mapFields(function (field) {
          var _field = field,
              fieldName = _field.fieldName;
          var defaultLanguageId = props.defaultLanguageId,
              editingLanguageId = props.editingLanguageId;

          if (fieldName === 'validation') {
            field = _objectSpread({}, field, {
              validation: _objectSpread({}, field.validation, {
                fieldName: fieldProperties.fieldName
              })
            });
          }

          return (0, _fieldSupport.localizeField)(field, defaultLanguageId, editingLanguageId);
        })
      })
    });

    return {
      activePage: activePage,
      focusedField: focusedField,
      previousFocusedField: focusedField
    };
  };

  var _default = handleFieldClicked;
  exports["default"] = _default;
  //# sourceMappingURL=fieldClickedHandler.es.js.map
});
//# sourceMappingURL=fieldClickedHandler.es.js.map