/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.context;

import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializer;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializerRequest;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextVisitor;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"dynamic.data.mapping.form.builder.context.deserializer.type=formValues"}, service={DDMFormContextDeserializer.class})
public class DDMFormContextToDDMFormValues
implements DDMFormContextDeserializer<DDMFormValues> {
    @Reference
    protected JSONFactory jsonFactory;

    public DDMFormValues deserialize(DDMFormContextDeserializerRequest ddmFormContextDeserializerRequest) throws PortalException {
        String serializedFormContext = (String)ddmFormContextDeserializerRequest.getProperty("serializedFormContext");
        if (Validator.isNull((String)serializedFormContext)) {
            throw new IllegalStateException("The property \"serializedFormContext\" is required");
        }
        DDMForm ddmForm = (DDMForm)ddmFormContextDeserializerRequest.getProperty("ddmForm");
        if (Validator.isNull((String)serializedFormContext)) {
            throw new IllegalStateException("The property \"ddmForm\" is required");
        }
        Locale currentLocale = (Locale)ddmFormContextDeserializerRequest.getProperty("currentLocale");
        if (currentLocale == null) {
            currentLocale = LocaleThreadLocal.getSiteDefaultLocale();
        }
        return this.deserialize(ddmForm, serializedFormContext, currentLocale);
    }

    protected DDMFormValues deserialize(DDMForm ddmForm, String serializedFormContext, Locale currentLocale) throws PortalException {
        JSONObject jsonObject = this.jsonFactory.createJSONObject(serializedFormContext);
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.addAvailableLocale(currentLocale);
        ddmFormValues.setDefaultLocale(currentLocale);
        this.setDDMFormValuesDDMFormFieldValues(jsonObject.getJSONArray("pages"), ddmFormValues);
        return ddmFormValues;
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(JSONArray jsonArray, DDMForm ddmForm) {
        final ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        final Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFormContextVisitor ddmFormTemplateContextVisitor = new DDMFormContextVisitor(jsonArray);
        ddmFormTemplateContextVisitor.onVisitField((Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject fieldJSONObject) {
                DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
                String name = fieldJSONObject.getString("fieldName");
                String instanceId = fieldJSONObject.getString("instanceId");
                ddmFormFieldValue.setName(name);
                ddmFormFieldValue.setInstanceId(instanceId);
                DDMFormContextToDDMFormValues.this.setDDMFormFieldValueValue(fieldJSONObject, (DDMFormField)ddmFormFieldsMap.get(name), ddmFormFieldValue);
                ddmFormFieldValues.add(ddmFormFieldValue);
            }
        });
        ddmFormTemplateContextVisitor.visit();
        return ddmFormFieldValues;
    }

    protected Value getLocalizedValue(JSONObject jsonObject) {
        LocalizedValue value = new LocalizedValue(LocaleUtil.getSiteDefault());
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String languageId = (String)iterator.next();
            value.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return value;
    }

    protected void setDDMFormFieldValueValue(JSONObject fieldJSONObject, DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        if (ddmFormField == null || ddmFormField.isTransient()) {
            return;
        }
        String type = ddmFormField.getType();
        if (ddmFormField.isLocalizable()) {
            Value value = this.getLocalizedValue(fieldJSONObject.getJSONObject("localizedValue"));
            ddmFormFieldValue.setValue(value);
        } else if (Objects.equals(type, "checkbox")) {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(String.valueOf(fieldJSONObject.getBoolean("value"))));
        } else {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(fieldJSONObject.getString("value")));
        }
    }

    protected void setDDMFormValuesDDMFormFieldValues(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValues(jsonArray, ddmFormValues.getDDMForm());
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }
}

