/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.context;

import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializer;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializerRequest;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextVisitor;
import com.liferay.dynamic.data.mapping.form.builder.rule.DDMFormRuleDeserializer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"dynamic.data.mapping.form.builder.context.deserializer.type=form"}, service={DDMFormContextDeserializer.class})
public class DDMFormContextToDDMForm
implements DDMFormContextDeserializer<DDMForm> {
    @Reference
    protected DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker;
    @Reference
    protected DDMFormRuleDeserializer ddmFormRuleDeserializer;
    @Reference
    protected JSONFactory jsonFactory;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormContextToDDMForm.class);

    public DDMForm deserialize(DDMFormContextDeserializerRequest ddmFormContextDeserializerRequest) throws PortalException {
        String serializedFormContext = (String)ddmFormContextDeserializerRequest.getProperty("serializedFormContext");
        if (Validator.isNull((String)serializedFormContext)) {
            throw new IllegalStateException("The property \"serializedFormContext\" is required");
        }
        return this.deserialize(serializedFormContext);
    }

    protected LocalizedValue createLocalizedValue(JSONObject jsonObject, Locale defaultLocale) {
        LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String languageId = (String)iterator.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected DDMForm deserialize(String serializedFormContext) throws PortalException {
        DDMForm ddmForm = new DDMForm();
        JSONObject jsonObject = this.jsonFactory.createJSONObject(serializedFormContext);
        this.setDDMFormAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmForm);
        this.setDDMFormDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmForm);
        this.setDDMFormFields(jsonObject.getJSONArray("pages"), ddmForm);
        this.setDDMFormRules(jsonObject.getJSONArray("rules"), ddmForm);
        this.setDDMFormSuccessPageSettings(jsonObject.getJSONObject("successPageSettings"), ddmForm);
        return ddmForm;
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            availableLocales.add(LocaleUtil.fromLanguageId((String)jsonArray.getString(i)));
        }
        return availableLocales;
    }

    protected Object getBooleanValue(String type, String serializedValue, Locale defaultLocale) {
        Object value = this.getValueFromValueAccessor(type, serializedValue, defaultLocale);
        if (!(value instanceof Boolean)) {
            value = Boolean.valueOf(serializedValue);
        }
        return value;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(JSONObject jsonObject, Set<Locale> availableLocales, Locale defaultLocale) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (Locale availableLocale : availableLocales) {
            JSONArray jsonArray = jsonObject.getJSONArray(LocaleUtil.toLanguageId((Locale)availableLocale));
            if (jsonArray == null) {
                jsonArray = jsonObject.getJSONArray(defaultLanguageId);
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject optionJSONObject = jsonArray.getJSONObject(i);
                ddmFormFieldOptions.addOptionLabel(optionJSONObject.getString("value"), availableLocale, optionJSONObject.getString("label"));
            }
        }
        ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        return ddmFormFieldOptions;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(String serializedValue, Set<Locale> availableLocales, Locale defaultLocale) throws PortalException {
        if (Validator.isNull((String)serializedValue)) {
            return new DDMFormFieldOptions();
        }
        JSONObject jsonObject = this.jsonFactory.createJSONObject(serializedValue);
        return this.getDDMFormFieldOptions(jsonObject, availableLocales, defaultLocale);
    }

    protected Object getDDMFormFieldPropertyValue(String serializedValue, boolean localizable, String dataType, String type, Set<Locale> availableLocales, Locale defaultLocale) throws PortalException {
        if (Objects.equals(dataType, "ddm-options")) {
            return this.getDDMFormFieldOptions(serializedValue, availableLocales, defaultLocale);
        }
        if (Objects.equals(dataType, "boolean")) {
            return this.getBooleanValue(type, serializedValue, defaultLocale);
        }
        if (Objects.equals(type, "validation")) {
            return this.getDDMFormFieldValidation(availableLocales, defaultLocale, serializedValue);
        }
        if (localizable) {
            return this.getLocalizedValue(serializedValue, type, availableLocales, defaultLocale);
        }
        if (Objects.equals(type, "select")) {
            return this.getSelectValue(type, serializedValue, defaultLocale);
        }
        return serializedValue;
    }

    protected DDMFormFieldValidation getDDMFormFieldValidation(Set<Locale> availableLocales, Locale defaultLocale, String serializedValue) throws PortalException {
        if (Validator.isNull((String)serializedValue)) {
            return null;
        }
        JSONObject jsonObject = this.jsonFactory.createJSONObject(serializedValue);
        final JSONObject expressionJSONObject = jsonObject.getJSONObject("expression");
        if (Validator.isNull((String)expressionJSONObject.getString("value"))) {
            return null;
        }
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        if (expressionJSONObject != null) {
            ddmFormFieldValidation.setDDMFormFieldValidationExpression(new DDMFormFieldValidationExpression(){
                {
                    this.setName(expressionJSONObject.getString("name"));
                    this.setValue(expressionJSONObject.getString("value"));
                }
            });
        }
        LocalizedValue errorMessageLocalizedValue = null;
        JSONObject errorMessageJSONObject = jsonObject.getJSONObject("errorMessage");
        if (errorMessageJSONObject == null) {
            errorMessageLocalizedValue = new LocalizedValue();
            errorMessageLocalizedValue.addString(defaultLocale, jsonObject.getString("errorMessage"));
        } else {
            errorMessageLocalizedValue = this.getLocalizedValue(errorMessageJSONObject, availableLocales);
        }
        ddmFormFieldValidation.setErrorMessageLocalizedValue(errorMessageLocalizedValue);
        LocalizedValue parameterLocalizedValue = null;
        JSONObject parameterJSONObject = jsonObject.getJSONObject("parameter");
        if (parameterJSONObject == null) {
            parameterLocalizedValue = new LocalizedValue();
            parameterLocalizedValue.addString(defaultLocale, jsonObject.getString("parameter"));
        } else {
            parameterLocalizedValue = this.getLocalizedValue(parameterJSONObject, availableLocales);
        }
        ddmFormFieldValidation.setParameterLocalizedValue(parameterLocalizedValue);
        return ddmFormFieldValidation;
    }

    protected LocalizedValue getLocalizedValue(JSONObject jsonObject, Set<Locale> availableLocales) {
        LocalizedValue localizedValue = new LocalizedValue();
        if (jsonObject == null) {
            return localizedValue;
        }
        for (Locale availableLocale : availableLocales) {
            String languageId = LocaleUtil.toLanguageId((Locale)availableLocale);
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected LocalizedValue getLocalizedValue(String serializedValue, String type, Set<Locale> availableLocales, Locale defaultLocale) throws PortalException {
        LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
        JSONObject jsonObject = this.jsonFactory.createJSONObject(serializedValue);
        String defaultValueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)defaultLocale));
        for (Locale availableLocale : availableLocales) {
            String valueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)availableLocale), defaultValueString);
            valueString = String.valueOf(this.getValueFromValueAccessor(type, valueString, defaultLocale));
            localizedValue.addString(availableLocale, valueString);
        }
        return localizedValue;
    }

    protected Object getSelectValue(String type, String serializedValue, Locale defaultLocale) throws JSONException {
        Object value = this.getValueFromValueAccessor(type, serializedValue, defaultLocale);
        if (!(value instanceof JSONArray)) {
            value = this.jsonFactory.createJSONArray(serializedValue);
        }
        return value;
    }

    protected Object getValueFromValueAccessor(String type, String serializedValue, Locale defaultLocale) {
        Object value;
        DDMFormFieldValueAccessor ddmFormFieldValueAccessor = this.ddmFormFieldTypeServicesTracker.getDDMFormFieldValueAccessor(type);
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setValue((Value)new UnlocalizedValue(serializedValue));
        if (ddmFormFieldValueAccessor != null && !((value = ddmFormFieldValueAccessor.getValue(ddmFormFieldValue, defaultLocale)) instanceof BigDecimal)) {
            return value;
        }
        return serializedValue;
    }

    protected void setDDMFormAvailableLocales(JSONArray jsonArray, DDMForm ddmForm) {
        ddmForm.setAvailableLocales(this.getAvailableLocales(jsonArray));
    }

    protected void setDDMFormDefaultLocale(String defaultLanguageId, DDMForm ddmForm) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmForm.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormFields(JSONArray jsonArray, final DDMForm ddmForm) {
        DDMFormContextVisitor ddmFormTemplateContextVisitor = new DDMFormContextVisitor(jsonArray);
        ddmFormTemplateContextVisitor.onVisitField((Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject jsonObject) {
                DDMFormField ddmFormField = this.createDDMFormField(jsonObject);
                ddmForm.addDDMFormField(ddmFormField);
            }

            protected DDMFormField createDDMFormField(JSONObject jsonObject) {
                String name = jsonObject.getString("name");
                String type = jsonObject.getString("type");
                DDMFormField ddmFormField = new DDMFormField(name, type);
                if (jsonObject.has("nestedFields")) {
                    JSONArray nestedFields = jsonObject.getJSONArray("nestedFields");
                    for (int i = 0; i < nestedFields.length(); ++i) {
                        DDMFormField nestedDDMFormField = this.createDDMFormField(nestedFields.getJSONObject(i));
                        ddmFormField.addNestedDDMFormField(nestedDDMFormField);
                    }
                }
                DDMFormContextToDDMForm.this.setDDMFormFieldSettings(jsonObject.getJSONObject("settingsContext"), ddmForm, ddmFormField);
                return ddmFormField;
            }
        });
        ddmFormTemplateContextVisitor.visit();
    }

    protected void setDDMFormFieldSettings(JSONObject jsonObject, final DDMForm ddmForm, final DDMFormField ddmFormField) {
        DDMFormContextVisitor ddmFormTemplateContextVisitor = new DDMFormContextVisitor(jsonObject.getJSONArray("pages"));
        ddmFormTemplateContextVisitor.onVisitField((Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject jsonObject) {
                boolean localizable = jsonObject.getBoolean("localizable", false);
                String propertyName = jsonObject.getString("fieldName");
                String value = jsonObject.getString(this.getValueProperty(localizable));
                String dataType = jsonObject.getString("dataType");
                String type = jsonObject.getString("type");
                try {
                    Object propertyValue = DDMFormContextToDDMForm.this.getDDMFormFieldPropertyValue(value, localizable, dataType, type, ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
                    ddmFormField.setProperty(propertyName, propertyValue);
                }
                catch (PortalException portalException) {
                    _log.error((Object)String.format("Unable to set the property \"%s\" of the field \"%s\"", propertyName, ddmFormField.getName()), (Throwable)portalException);
                }
            }

            protected String getValueProperty(boolean localizable) {
                if (localizable) {
                    return "localizedValue";
                }
                return "value";
            }
        });
        ddmFormTemplateContextVisitor.visit();
    }

    protected void setDDMFormRules(JSONArray jsonArray, DDMForm ddmForm) throws PortalException {
        ddmForm.setDDMFormRules(this.ddmFormRuleDeserializer.deserialize(ddmForm, jsonArray));
    }

    protected void setDDMFormSuccessPageSettings(JSONObject jsonObject, DDMForm ddmForm) {
        if (jsonObject == null) {
            return;
        }
        DDMFormSuccessPageSettings ddmFormSuccessPageSettings = new DDMFormSuccessPageSettings();
        Locale defaultLocale = ddmForm.getDefaultLocale();
        ddmFormSuccessPageSettings.setBody(this.createLocalizedValue(jsonObject.getJSONObject("body"), defaultLocale));
        ddmFormSuccessPageSettings.setTitle(this.createLocalizedValue(jsonObject.getJSONObject("title"), defaultLocale));
        ddmFormSuccessPageSettings.setEnabled(jsonObject.getBoolean("enabled"));
        ddmForm.setDDMFormSuccessPageSettings(ddmFormSuccessPageSettings);
    }
}

