/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'dynamic-data-mapping-form-renderer';

const deleteLanguageId = (languageId, pages) => {
	const visitor = new PagesVisitor(pages);

	return visitor.mapFields((field) => {
		const {localizedValue} = field;
		const newLocalizedValue = {...localizedValue};

		delete newLocalizedValue[languageId];

		return {
			...field,
			localizedValue: newLocalizedValue,
		};
	});
};

export const handleLanguageIdDeleted = (focusedField, pages, languageId) => {
	if (focusedField.settingsContext) {
		focusedField = {
			...focusedField,
			settingsContext: {
				...focusedField.settingsContext,
				pages: deleteLanguageId(
					languageId,
					focusedField.settingsContext.pages
				),
			},
		};
	}

	const visitor = new PagesVisitor(pages);

	pages = visitor.mapPages((page) => {
		const {localizedDescription, localizedTitle} = page;

		delete localizedDescription[languageId];
		delete localizedTitle[languageId];

		return {
			...page,
			localizedDescription,
			localizedTitle,
		};
	});

	visitor.setPages(pages);

	pages = visitor.mapFields((field) => {
		const {settingsContext} = field;

		return {
			...field,
			settingsContext: {
				...settingsContext,
				pages: deleteLanguageId(languageId, settingsContext.pages),
			},
		};
	});

	return {
		focusedField,
		pages,
	};
};

export default handleLanguageIdDeleted;
