/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {FormSupport} from 'dynamic-data-mapping-form-renderer';

import {FIELD_TYPE_FIELDSET} from '../../../util/constants.es';
import {getParentField} from '../../../util/fieldSupport.es';
import {addField} from './fieldAddedHandler.es';
import handleFieldDeleted from './fieldDeletedHandler.es';
import handleSectionAdded from './sectionAddedHandler.es';

export default (props, state, event) => {
	const {
		sourceFieldName,
		sourceFieldPage,
		targetFieldName,
		targetIndexes,
		targetParentFieldName,
	} = event;

	const deletedState = handleFieldDeleted(props, state, {
		activePage: sourceFieldPage,
		fieldName: sourceFieldName,
	});
	const sourceField = FormSupport.findFieldByFieldName(
		state.pages,
		sourceFieldName
	);

	let mergedState = {...deletedState};
	let parentField = getParentField(state.pages, sourceFieldName);

	if (
		parentField &&
		parentField.type === FIELD_TYPE_FIELDSET &&
		parentField.nestedFields.length === 1
	) {
		let parentFieldName = parentField ? parentField.fieldName : '';

		do {
			if (parentField) {
				parentFieldName = parentField.fieldName;
			}

			parentField = getParentField(state.pages, parentField.fieldName);
		} while (
			parentField &&
			parentField.type === FIELD_TYPE_FIELDSET &&
			parentField.fieldName !== targetParentFieldName &&
			parentField.nestedFields.length === 1
		);

		if (parentFieldName) {
			mergedState = {
				...handleFieldDeleted(props, state, {
					activePage: sourceFieldPage,
					fieldName: parentFieldName,
				}),
			};
		}
	}

	if (targetFieldName) {
		return {
			...handleSectionAdded(
				props,
				{
					...state,
					pages: deletedState.pages,
				},
				{
					data: {
						fieldName: targetFieldName,
						parentFieldName: targetParentFieldName,
					},
					indexes: targetIndexes,
					newField: sourceField,
				}
			),
		};
	}

	return {
		...addField(props, {
			indexes: targetIndexes,
			newField: sourceField,
			pages: mergedState.pages,
			parentFieldName: targetParentFieldName,
		}),
	};
};
