/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {FormSupport, PagesVisitor} from 'dynamic-data-mapping-form-renderer';

import {getParentFieldSet, localizeField} from '../../../util/fieldSupport.es';

const handleFieldClicked = (props, state, event) => {
	let {fieldName} = event;
	const {activePage} = event;
	const {pages} = state;

	const parentFieldSet = getParentFieldSet(pages, fieldName);

	if (parentFieldSet) {
		fieldName = parentFieldSet.fieldName;
	}

	const fieldProperties = FormSupport.findFieldByFieldName(pages, fieldName);
	const {settingsContext} = fieldProperties;
	const visitor = new PagesVisitor(settingsContext.pages);

	const focusedField = {
		...fieldProperties,
		settingsContext: {
			...settingsContext,
			currentPage: activePage,
			pages: visitor.mapFields((field) => {
				const {fieldName} = field;
				const {defaultLanguageId, editingLanguageId} = props;

				if (fieldName === 'validation') {
					field = {
						...field,
						validation: {
							...field.validation,
							fieldName: fieldProperties.fieldName,
						},
					};
				}

				return localizeField(
					field,
					defaultLanguageId,
					editingLanguageId
				);
			}),
		},
	};

	return {
		activePage,
		focusedField,
		previousFocusedField: focusedField,
	};
};

export default handleFieldClicked;
