/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import Component from 'metal-jsx';
import {Config} from 'metal-state';

import formBuilderProps from './props.es';

const withMultiplePages = (ChildComponent) => {
	class MultiplePages extends Component {
		getPages() {
			let {pages} = this.props;
			const {paginationMode, successPageSettings} = this.props;

			if (successPageSettings.enabled) {
				pages = [
					...pages,
					{
						contentRenderer: 'success',
						paginationItemRenderer: `${paginationMode}_success`,
						rows: [],
						successPageSettings,
					},
				];
			}

			return pages.map((page) => {
				return {
					...page,
					enabled: true,
				};
			});
		}

		getPaginationPosition() {
			const {pages, paginationMode} = this.props;
			const position = paginationMode === 'wizard' ? 'top' : 'bottom';

			return pages.length > 1 ? position : 'top';
		}

		render() {
			return (
				<div
					class={`container ddm-paginated-builder ${this.getPaginationPosition()}`}
				>
					<ChildComponent {...this.props} pages={this.getPages()} />
				</div>
			);
		}
	}

	MultiplePages.PROPS = {

		/**
		 * @instance
		 * @memberof LayoutProvider
		 * @type {boolean}
		 */

		allowSuccessPage: Config.bool().value(true),

		...formBuilderProps,
	};

	MultiplePages.STATE = {

		/**
		 * @default false
		 * @instance
		 * @memberof FormRenderer
		 * @type {boolean}
		 */

		dropdownExpanded: Config.bool().value(false).internal(),
	};

	return MultiplePages;
};

export default withMultiplePages;
