Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.20/js/components/LayoutProvider/handlers/fieldSetAddedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../util/settingsContext.es', './fieldAddedHandler.es', './sectionAddedHandler.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _settingsContext = require("../util/settingsContext.es");

  var _fieldAddedHandler = require("./fieldAddedHandler.es");

  var _sectionAddedHandler = require("./sectionAddedHandler.es");

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var handleFieldSetAdded = function handleFieldSetAdded(props, state, event) {
    var fieldSet = event.fieldSet,
        indexes = event.indexes,
        parentFieldName = event.parentFieldName;
    var pages = state.pages;
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(fieldSet.pages);
    var nestedFields = [];
    visitor.mapFields(function (nestedField) {
      nestedFields.push(nestedField);
    });
    var sectionField = (0, _sectionAddedHandler.createSection)(props, {
      skipFieldNameGeneration: false
    }, nestedFields);
    sectionField = (0, _settingsContext.updateField)(props, sectionField, 'dataDefinitionId', fieldSet.id);
    return (0, _fieldAddedHandler.addField)(props, {
      indexes: indexes,
      newField: (0, _settingsContext.updateField)(props, sectionField, 'label', fieldSet.title),
      pages: pages,
      parentFieldName: parentFieldName
    });
  };

  var _default = handleFieldSetAdded;
  exports["default"] = _default;
  //# sourceMappingURL=fieldSetAddedHandler.es.js.map
});
//# sourceMappingURL=fieldSetAddedHandler.es.js.map