Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.20/js/components/LayoutProvider/handlers/fieldDeletedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../RuleBuilder/RulesSupport.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.handleFieldDeleted = exports.removeField = exports.formatRules = void 0;

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _RulesSupport = _interopRequireDefault(require("../../RuleBuilder/RulesSupport.es"));

  var _settingsContext = require("../util/settingsContext.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var formatRules = function formatRules(state, pages) {
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
    var rules = (state.rules || []).map(function (rule) {
      var actions = rule.actions,
          conditions = rule.conditions;
      conditions.forEach(function (condition) {
        var firstOperandFieldExists = false;
        var secondOperandFieldExists = false;
        var secondOperand = condition.operands[1];
        visitor.mapFields(function (_ref) {
          var fieldName = _ref.fieldName;

          if (condition.operands[0].value === fieldName) {
            firstOperandFieldExists = true;
          }

          if (secondOperand && secondOperand.value === fieldName) {
            secondOperandFieldExists = true;
          }
        });

        if (condition.operands[0].value === 'user') {
          firstOperandFieldExists = true;
        }

        if (!firstOperandFieldExists) {
          _RulesSupport["default"].clearAllConditionFieldValues(condition);
        }

        if (!secondOperandFieldExists && secondOperand && secondOperand.type == 'field') {
          _RulesSupport["default"].clearSecondOperandValue(condition);
        }
      });
      return _objectSpread({}, rule, {
        actions: _RulesSupport["default"].syncActions(pages, actions),
        conditions: conditions
      });
    });
    return rules;
  };

  exports.formatRules = formatRules;

  var removeField = function removeField(props, pages, fieldName) {
    var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);

    var filter = function filter(fields) {
      return fields.filter(function (field) {
        return field.fieldName !== fieldName;
      }).map(function (field) {
        var pages = [{
          rows: field.rows
        }];
        var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
        var nestedFields = field.nestedFields ? filter(field.nestedFields) : [];
        field = (0, _settingsContext.updateField)(props, field, 'nestedFields', nestedFields);
        var rows = field.rows ? _dynamicDataMappingFormRenderer.FormSupport.removeEmptyRows(visitor.mapColumns(function (column) {
          return _objectSpread({}, column, {
            fields: column.fields.filter(function (nestedFieldName) {
              return fieldName !== nestedFieldName;
            })
          });
        }), 0) : [];
        field = (0, _settingsContext.updateField)(props, field, 'rows', rows);
        return _objectSpread({}, field, {
          nestedFields: nestedFields,
          rows: rows
        });
      });
    };

    return visitor.mapColumns(function (column) {
      return _objectSpread({}, column, {
        fields: filter(column.fields)
      });
    });
  };

  exports.removeField = removeField;

  var handleFieldDeleted = function handleFieldDeleted(props, state, _ref2) {
    var fieldName = _ref2.fieldName;
    var activePage = state.activePage,
        pages = state.pages;
    var newPages = pages.map(function (page, pageIndex) {
      if (activePage === pageIndex) {
        return _objectSpread({}, page, {
          rows: _dynamicDataMappingFormRenderer.FormSupport.removeEmptyRows(removeField(props, pages, fieldName), pageIndex)
        });
      }

      return page;
    });
    return {
      focusedField: {},
      pages: newPages,
      rules: formatRules(state, newPages)
    };
  };

  exports.handleFieldDeleted = handleFieldDeleted;
  var _default = handleFieldDeleted;
  exports["default"] = _default;
  //# sourceMappingURL=fieldDeletedHandler.es.js.map
});
//# sourceMappingURL=fieldDeletedHandler.es.js.map