Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.20/js/components/FormBuilder/FieldActionsDropDown.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'dynamic-data-mapping-form-renderer', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state', '../../util/config.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _clayDropdown = require("frontend-taglib-clay$clay-dropdown");

  var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalPosition = require("frontend-js-metal-web$metal-position");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _config = require("../../util/config.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var getFieldContainer = function getFieldContainer(fieldName) {
    return document.querySelector(".ddm-field-container[data-field-name=\"".concat(fieldName, "\"]"));
  };

  var FieldActionsDropDown =
  /*#__PURE__*/
  function (_Component) {
    _inherits(FieldActionsDropDown, _Component);

    function FieldActionsDropDown() {
      _classCallCheck(this, FieldActionsDropDown);

      return _possibleConstructorReturn(this, _getPrototypeOf(FieldActionsDropDown).apply(this, arguments));
    }

    _createClass(FieldActionsDropDown, [{
      key: "attached",
      value: function attached() {
        this._eventHandler.add(_metalDom["default"].on(window, 'resize', this._align.bind(this)));
      }
    }, {
      key: "close",
      value: function close() {
        this.setState({
          expanded: false
        });
      }
    }, {
      key: "created",
      value: function created() {
        this._eventHandler = new _metalEvents.EventHandler();
        this.close();
      }
    }, {
      key: "disposed",
      value: function disposed() {
        this._eventHandler.removeAllListeners();
      }
    }, {
      key: "open",
      value: function open() {
        this.setState({
          expanded: true
        });
      }
    }, {
      key: "render",
      value: function render() {
        var expanded = this.state.expanded;
        var _this$props = this.props,
            disabled = _this$props.disabled,
            items = _this$props.items,
            spritemap = _this$props.spritemap,
            visible = _this$props.visible;
        IncrementalDOM.elementOpen("div", null, null, "class", "ddm-field-actions-container ".concat(visible ? '' : 'hide'), "onMouseDown", this._handleOnMouseDown.bind(this), "onMouseLeave", this._handleOnMouseLeave.bind(this));
        IncrementalDOM.elementOpen("span", null, null, "class", "actions-label");
        iDOMHelpers.renderArbitrary(this._getLabel());
        IncrementalDOM.elementClose("span");
        IncrementalDOM.elementVoid(_clayDropdown.ClayActionsDropdown, null, null, "disabled", disabled, "events", {
          expandedChanged: this._handleExpandedChanged.bind(this),
          itemClicked: this._handleItemClicked.bind(this)
        }, "expanded", expanded, "items", items, "spritemap", spritemap, "ref", "dropdown");
        return IncrementalDOM.elementClose("div");
      }
    }, {
      key: "rendered",
      value: function rendered() {
        var _this = this;

        this._align();

        requestAnimationFrame(function () {
          _this._align();

          _this.refs.dropdown.refs.dropdown.refs.portal.emit('rendered');
        });
      }
    }, {
      key: "syncVisible",
      value: function syncVisible(visible) {
        if (visible) {
          this.element.classList.remove('hide');
        } else {
          this.element.classList.add('hide');
        }
      }
    }, {
      key: "_align",
      value: function _align() {
        var fieldName = this.state.fieldName;
        var fieldContainer = getFieldContainer(fieldName);

        if (this.element && fieldContainer) {
          _metalPosition.Align.align(this.element, fieldContainer, _metalPosition.Align.TopLeft);
        }
      }
    }, {
      key: "_getLabel",
      value: function _getLabel() {
        var fieldName = this.state.fieldName;
        var _this$props2 = this.props,
            fieldTypes = _this$props2.fieldTypes,
            pages = _this$props2.pages;

        var field = _dynamicDataMappingFormRenderer.FormSupport.findFieldByName(pages, fieldName);

        return field && fieldTypes.find(function (fieldType) {
          return fieldType.name === field.type;
        }).label;
      }
    }, {
      key: "_handleOnMouseDown",
      value: function _handleOnMouseDown(event) {
        var dropdown = this.refs.dropdown;
        event.stopImmediatePropagation();
        event.stopPropagation();

        if (!dropdown.element.contains(event.target)) {
          var dispatch = this.context.dispatch;
          var fieldName = this.state.fieldName;
          dispatch('fieldClicked', {
            fieldName: fieldName
          });
        }
      }
    }, {
      key: "_handleOnMouseLeave",
      value: function _handleOnMouseLeave(event) {
        var fieldName = this.state.fieldName;

        if (!fieldName) {
          return;
        }

        this.emit('mouseLeave', _objectSpread({}, event, {
          container: getFieldContainer(fieldName),
          relatedTarget: event.relatedTarget
        }));
      }
    }, {
      key: "_handleExpandedChanged",
      value: function _handleExpandedChanged(_ref) {
        var newVal = _ref.newVal;
        this.setState({
          expanded: newVal
        });
      }
    }, {
      key: "_handleItemClicked",
      value: function _handleItemClicked(_ref2) {
        var action = _ref2.data.item.action;
        var fieldName = this.state.fieldName;
        action(fieldName);
        this.close();
      }
    }]);

    return FieldActionsDropDown;
  }(_metalJsx["default"]);

  FieldActionsDropDown.PROPS = {
    /**
     * @default false
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!boolean}
     */
    disabled: _metalState.Config.bool().value(false),

    /**
     * @default []
     * @instance
     * @memberof FieldActionsDropDown
     * @type {?array<object>}
     */
    fieldTypes: _metalState.Config.array().value([]),

    /**
     * @default []
     * @instance
     * @memberof FieldActionsDropDown
     * @type {?array<object>}
     */
    pages: _metalState.Config.arrayOf(_config.pageStructure).value([]),

    /**
     * @default undefined
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };
  FieldActionsDropDown.STATE = {
    /**
     * @default false
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!boolean}
     */
    expanded: _metalState.Config.bool(),

    /**
     * @default undefined
     * @instance
     * @memberof FieldActionsDropDown
     * @type {!string}
     */
    fieldName: _metalState.Config.string()
  };
  var _default = FieldActionsDropDown;
  exports["default"] = _default;
  //# sourceMappingURL=FieldActionsDropDown.es.js.map
});
//# sourceMappingURL=FieldActionsDropDown.es.js.map