/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter;

import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.AutoFillDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.CalculateDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.DefaultDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.JumpToPageDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRule;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.spi.converter.model.SPIDDMFormRuleCondition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormRuleDeserializer.class})
public class DDMFormRuleDeserializer {
    @Reference
    private JSONFactory _jsonFactory;

    public List<SPIDDMFormRule> deserialize(String rules) throws PortalException {
        JSONArray rulesJSONArray = this._jsonFactory.createJSONArray(rules);
        ArrayList<SPIDDMFormRule> spiDDMFormRules = new ArrayList<SPIDDMFormRule>(rulesJSONArray.length());
        for (int i = 0; i < rulesJSONArray.length(); ++i) {
            SPIDDMFormRule spiDDMFormRule = this.deserializeSPIDDMFormRule(rulesJSONArray.getJSONObject(i));
            spiDDMFormRules.add(spiDDMFormRule);
        }
        return spiDDMFormRules;
    }

    protected SPIDDMFormRule deserializeSPIDDMFormRule(JSONObject ruleJSONObject) {
        SPIDDMFormRule spiDDMFormRule = new SPIDDMFormRule();
        List<SPIDDMFormRuleAction> spiDDMFormRuleActions = this.deserializeSPIDDMFormRuleActions(ruleJSONObject.getJSONArray("actions"));
        spiDDMFormRule.setSPIDDMFormRuleActions(spiDDMFormRuleActions);
        List<SPIDDMFormRuleCondition> spiDDMFormRuleConditions = this.deserializeSPIDDMFormRuleConditions(ruleJSONObject.getJSONArray("conditions"));
        spiDDMFormRule.setSPIDDMFormRuleConditions(spiDDMFormRuleConditions);
        spiDDMFormRule.setLogicalOperator(ruleJSONObject.getString("logical-operator"));
        return spiDDMFormRule;
    }

    protected <T extends SPIDDMFormRuleAction> SPIDDMFormRuleAction deserializeSPIDDMFormRuleAction(JSONObject actionJSONObject, Class<T> targetClass) {
        JSONDeserializer jsonDeserializer = this._jsonFactory.createJSONDeserializer();
        return (SPIDDMFormRuleAction)jsonDeserializer.deserialize(actionJSONObject.toJSONString(), targetClass);
    }

    protected List<SPIDDMFormRuleAction> deserializeSPIDDMFormRuleActions(JSONArray actionsJSONArray) {
        ArrayList<SPIDDMFormRuleAction> spiDDMFormRuleActions = new ArrayList<SPIDDMFormRuleAction>();
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            String action = actionJSONObject.getString("action");
            Class<? extends SPIDDMFormRuleAction> clazz = this.getSPIDDMFormRuleActionClass(action);
            SPIDDMFormRuleAction spiDDMFormRuleAction = this.deserializeSPIDDMFormRuleAction(actionJSONObject, clazz);
            spiDDMFormRuleActions.add(spiDDMFormRuleAction);
        }
        return spiDDMFormRuleActions;
    }

    protected List<SPIDDMFormRuleCondition> deserializeSPIDDMFormRuleConditions(JSONArray conditionsJSONArray) {
        JSONDeserializer jsonDeserializer = this._jsonFactory.createJSONDeserializer();
        Object[] spiDDMFormRuleConditions = (SPIDDMFormRuleCondition[])jsonDeserializer.deserialize(conditionsJSONArray.toJSONString(), SPIDDMFormRuleCondition[].class);
        return ListUtil.fromArray((Object[])spiDDMFormRuleConditions);
    }

    protected Class<? extends SPIDDMFormRuleAction> getSPIDDMFormRuleActionClass(String action) {
        if (action.equals("auto-fill")) {
            return AutoFillDDMFormRuleAction.class;
        }
        if (action.equals("calculate")) {
            return CalculateDDMFormRuleAction.class;
        }
        if (action.equals("jump-to-page")) {
            return JumpToPageDDMFormRuleAction.class;
        }
        return DefaultDDMFormRuleAction.class;
    }
}

