/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {PagesVisitor} from 'dynamic-data-mapping-form-renderer';

const clearTargetValue = (actions, index) => {
	if (actions[index]) {
		actions[index].target = '';
	}

	return actions;
};

const clearFirstOperandValue = condition => {
	if (condition && condition.operands[0]) {
		condition.operands[0].type = '';
		condition.operands[0].value = '';
	}

	return condition;
};

const clearOperatorValue = condition => {
	if (condition) {
		condition.operator = '';
	}

	return condition;
};

const clearSecondOperandValue = condition => {
	if (condition && condition.operands[1]) {
		condition.operands[1].type = '';
		condition.operands[1].value = '';
	}

	return condition;
};

const clearAllConditionFieldValues = condition => {
	condition = clearFirstOperandValue(condition);
	condition = clearOperatorValue(condition);
	condition = clearSecondOperandValue(condition);

	return condition;
};

const syncActions = (pages, actions) => {
	const visitor = new PagesVisitor(pages);

	actions.forEach((action, index) => {
		let targetFieldExists = false;

		visitor.mapFields(({fieldName}) => {
			if (action.target === fieldName) {
				targetFieldExists = true;
			}
		});

		if (!targetFieldExists) {
			actions = clearTargetValue(actions, index);
		}
	});

	return actions;
};

export default {
	clearAllConditionFieldValues,
	clearFirstOperandValue,
	clearOperatorValue,
	clearSecondOperandValue,
	clearTargetValue,
	syncActions,
};
