import {PagesVisitor} from 'dynamic-data-mapping-form-renderer';

import {updateField} from '../util/settingsContext.es';
import {addField} from './fieldAddedHandler.es';
import {createSection} from './sectionAddedHandler.es';

/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

const handleFieldSetAdded = (props, state, event) => {
	const {fieldSet, indexes, parentFieldName} = event;
	const {pages} = state;
	const visitor = new PagesVisitor(fieldSet.pages);

	const nestedFields = [];

	visitor.mapFields(nestedField => {
		nestedFields.push(nestedField);
	});

	let sectionField = createSection(
		props,
		{skipFieldNameGeneration: false},
		nestedFields
	);

	sectionField = updateField(
		props,
		sectionField,
		'dataDefinitionId',
		fieldSet.id
	);

	return addField(props, {
		indexes,
		newField: updateField(props, sectionField, 'label', fieldSet.title),
		pages,
		parentFieldName,
	});
};

export default handleFieldSetAdded;
