Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.1/js/components/LayoutProvider/handlers/fieldAddedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../../../util/fieldSupport.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _fieldSupport = require("../../../util/fieldSupport.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var handleFieldAdded = function handleFieldAdded(props, state, event) {
    var fieldType = event.fieldType,
        indexes = event.indexes,
        _event$skipFieldNameG = event.skipFieldNameGeneration,
        skipFieldNameGeneration = _event$skipFieldNameG === void 0 ? false : _event$skipFieldNameG;
    var defaultLanguageId = props.defaultLanguageId,
        editingLanguageId = props.editingLanguageId,
        fieldNameGenerator = props.fieldNameGenerator,
        spritemap = props.spritemap;
    var newFieldName;

    if (skipFieldNameGeneration) {
      var _settingsContext = fieldType.settingsContext;
      var visitor = new _visitors.PagesVisitor(_settingsContext.pages);
      visitor.mapFields(function (_ref) {
        var fieldName = _ref.fieldName,
            value = _ref.value;

        if (fieldName === 'name') {
          newFieldName = value;
        }
      });
    } else {
      newFieldName = fieldNameGenerator(fieldType.label);
    }

    var focusedField = _objectSpread({}, fieldType, {
      fieldName: newFieldName,
      settingsContext: _objectSpread({}, fieldType.settingsContext, {
        pages: (0, _fieldSupport.normalizeSettingsContextPages)(fieldType.settingsContext.pages, editingLanguageId, fieldType, newFieldName),
        type: fieldType.name
      })
    });

    var fieldName = focusedField.fieldName,
        name = focusedField.name,
        settingsContext = focusedField.settingsContext;
    var pageIndex = indexes.pageIndex,
        rowIndex = indexes.rowIndex;
    var pages = state.pages;
    var columnIndex = indexes.columnIndex;

    var fieldProperties = _objectSpread({}, (0, _fieldSupport.getFieldProperties)(settingsContext, defaultLanguageId, editingLanguageId), {
      fieldName: fieldName,
      instanceId: (0, _fieldSupport.generateInstanceId)(8),
      name: name,
      settingsContext: settingsContext,
      spritemap: spritemap,
      type: fieldType.name
    });

    return {
      focusedField: _objectSpread({}, fieldProperties, {
        columnIndex: columnIndex,
        pageIndex: pageIndex,
        rowIndex: rowIndex
      }),
      pages: FormSupport.addFieldToColumn(pages, pageIndex, rowIndex, columnIndex, fieldProperties),
      previousFocusedField: fieldProperties
    };
  };

  var _default = handleFieldAdded;
  exports["default"] = _default;
  //# sourceMappingURL=fieldAddedHandler.es.js.map
});
//# sourceMappingURL=fieldAddedHandler.es.js.map