/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import * as FormSupport from 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es';

export default (props, state, {addedToPlaceholder, source, target}) => {
	let {pages} = state;
	const {columnIndex, pageIndex, rowIndex} = source;

	const column = FormSupport.getColumn(
		pages,
		pageIndex,
		rowIndex,
		columnIndex
	);
	const {fields} = column;

	pages = FormSupport.removeFields(pages, pageIndex, rowIndex, columnIndex);

	if (
		target.rowIndex > pages[pageIndex].rows.length - 1 ||
		addedToPlaceholder
	) {
		pages = FormSupport.addRow(
			pages,
			target.rowIndex,
			target.pageIndex,
			FormSupport.implAddRow(12, fields)
		);
	} else {
		pages = FormSupport.addFieldToColumn(
			pages,
			target.pageIndex,
			target.rowIndex,
			target.columnIndex,
			fields[0]
		);
	}

	pages[pageIndex].rows = FormSupport.removeEmptyRows(pages, pageIndex);

	return {
		pages
	};
};
