Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.93/js/components/LayoutProvider/handlers/columnResizedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.handleResizeRight = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _settingsContext = require("../util/settingsContext.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var getColumn = function getColumn(pages) {
    var nestedIndexes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    var column;
    var context = pages;
    nestedIndexes.forEach(function (indexes) {
      var columnIndex = indexes.columnIndex,
          pageIndex = indexes.pageIndex,
          rowIndex = indexes.rowIndex;
      column = FormSupport.getColumn(context, column ? 0 : pageIndex, rowIndex, columnIndex);

      if (column && context[0].nestedFields) {
        context = context[0].nestedFields.filter(function (nestedField) {
          return column.fields.includes(nestedField.fieldName);
        });
      } else {
        context = column && column.fields;
      }
    });
    return column;
  };

  var getContext = function getContext(context) {
    var nestedIndexes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    if (nestedIndexes.length) {
      nestedIndexes.forEach(function (indexes, i) {
        var columnIndex = indexes.columnIndex,
            pageIndex = indexes.pageIndex,
            rowIndex = indexes.rowIndex;
        var fields = context[i > 0 ? 0 : pageIndex].rows[rowIndex].columns[columnIndex].fields;

        if (context[0].nestedFields) {
          fields = fields.map(function (field) {
            return context[0].nestedFields.find(function (nestedField) {
              return nestedField.fieldName === field;
            });
          });
        }

        context = fields;
      });
    }

    return context;
  };

  var getColumnPosition = function getColumnPosition(context, indexes) {
    var columnIndex = indexes.columnIndex,
        pageIndex = indexes.pageIndex,
        rowIndex = indexes.rowIndex;
    return FormSupport.getColumnPosition(context, pageIndex, rowIndex, columnIndex);
  };

  var handleResizeRight = function handleResizeRight(props, state, source, indexes, columnTarget) {
    var pages = state.pages;
    var _indexes = indexes[indexes.length - 1],
        columnIndex = _indexes.columnIndex,
        pageIndex = _indexes.pageIndex,
        rowIndex = _indexes.rowIndex;
    var currentContext = getContext(pages, indexes.slice(0, -1));
    var currentColumn = getColumn(currentContext, [indexes[indexes.length - 1]]);
    var nextColumn = getColumn(currentContext, [{
      columnIndex: columnIndex + 1,
      pageIndex: pageIndex,
      rowIndex: rowIndex
    }]);
    var currentColumnPosition = getColumnPosition(currentContext, {
      columnIndex: columnIndex,
      pageIndex: indexes.length > 1 ? 0 : pageIndex,
      rowIndex: rowIndex
    });
    var newContext = currentContext;
    var newCurrentColumn;
    var newNextColumn;

    if (!nextColumn && currentColumn.size > currentColumnPosition - columnTarget && columnTarget < currentColumnPosition) {
      var newSize = currentColumnPosition - columnTarget;
      newCurrentColumn = _objectSpread({}, currentColumn, {
        size: currentColumn.size - newSize
      });
      newContext = FormSupport.addColumn(newContext, columnIndex + 1, indexes.length > 1 ? 0 : pageIndex, rowIndex, {
        fields: [],
        size: newSize
      });
    } else if (nextColumn) {
      var _newSize = Math.abs(currentColumnPosition - columnTarget);

      if (columnTarget < currentColumnPosition && currentColumn.size > _newSize) {
        newCurrentColumn = _objectSpread({}, currentColumn, {
          size: Math.max(currentColumn.size - _newSize, 1)
        });
        newNextColumn = _objectSpread({}, nextColumn, {
          size: Math.min(nextColumn.size + _newSize, 12)
        });
      } else if (columnTarget > currentColumnPosition) {
        if (nextColumn.size === 1 && nextColumn.fields.length === 0) {
          newCurrentColumn = _objectSpread({}, currentColumn, {
            size: currentColumn.size + _newSize
          });
          newContext = FormSupport.removeColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex + 1);
        } else if (nextColumn.size > _newSize) {
          newCurrentColumn = _objectSpread({}, currentColumn, {
            size: currentColumn.size + _newSize
          });
          newNextColumn = _objectSpread({}, nextColumn, {
            size: nextColumn.size - _newSize
          });
        }
      }
    }

    if (newCurrentColumn) {
      newContext = FormSupport.updateColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex, newCurrentColumn);
    }

    if (newNextColumn) {
      newContext = FormSupport.updateColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex + 1, newNextColumn);
    }

    if (indexes.length > 1) {
      newContext = [(0, _settingsContext.updateField)(props, newContext[0], 'rows', newContext[0].rows)];
      currentContext[0].settingsContext = newContext[0].settingsContext;
    }

    currentContext[indexes.length > 1 ? 0 : pageIndex].rows = newContext[indexes.length > 1 ? 0 : pageIndex].rows;
    return pages;
  };

  exports.handleResizeRight = handleResizeRight;

  var handleResizeLeft = function handleResizeLeft(props, state, source, indexes, columnTarget) {
    var pages = state.pages;
    var _indexes2 = indexes[indexes.length - 1],
        columnIndex = _indexes2.columnIndex,
        pageIndex = _indexes2.pageIndex,
        rowIndex = _indexes2.rowIndex;
    var currentContext = getContext(pages, indexes.slice(0, -1));
    var currentColumn = getColumn(currentContext, [indexes[indexes.length - 1]]);
    var previousColumn = getColumn(currentContext, [{
      columnIndex: columnIndex - 1,
      pageIndex: pageIndex,
      rowIndex: rowIndex
    }]);
    var previousColumnPosition = getColumnPosition(currentContext, {
      columnIndex: columnIndex - 1,
      pageIndex: indexes.length > 1 ? 0 : pageIndex,
      rowIndex: rowIndex
    });
    var newContext = currentContext;

    if (columnIndex === 0 && columnTarget > 0) {
      newContext = FormSupport.addColumn(newContext, columnIndex, indexes.length > 1 ? 0 : pageIndex, rowIndex, {
        fields: [],
        size: columnTarget
      });
      newContext = FormSupport.updateColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex + 1, _objectSpread({}, currentColumn, {
        size: currentColumn.size - columnTarget
      }));
      source.dataset.ddmFieldColumn = columnIndex + 1;
    } else if (previousColumn && previousColumn.size === 1 && previousColumn.fields.length === 0 && columnTarget <= previousColumnPosition) {
      newContext = FormSupport.removeColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex - 1);
      source.dataset.ddmFieldColumn = columnIndex - 1;
      newContext = FormSupport.updateColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex - 1, _objectSpread({}, currentColumn, {
        size: currentColumn.size + 1
      }));
    } else if (previousColumn) {
      var newSize = Math.abs(previousColumnPosition - columnTarget);

      if (previousColumnPosition >= columnTarget && previousColumn.size > newSize) {
        currentColumn.size += newSize;
        previousColumn.size -= newSize;
      } else if (previousColumnPosition < columnTarget && currentColumn.size > newSize) {
        currentColumn.size -= newSize;
        previousColumn.size += newSize;
      }

      newContext = FormSupport.updateColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex, currentColumn);
      newContext = FormSupport.updateColumn(newContext, indexes.length > 1 ? 0 : pageIndex, rowIndex, columnIndex - 1, previousColumn);
    }

    if (indexes.length > 1) {
      newContext = [(0, _settingsContext.updateField)(props, newContext[0], 'rows', newContext[0].rows)];
      currentContext[0].settingsContext = newContext[0].settingsContext;
    }

    currentContext[indexes.length > 1 ? 0 : pageIndex].rows = newContext[indexes.length > 1 ? 0 : pageIndex].rows;
    return pages;
  };

  var _default = function _default(props, state, source, container, column, direction) {
    var pages = state.pages;

    var newPages = _toConsumableArray(pages);

    var sourceIndexes = FormSupport.getNestedIndexes(container);
    var currentColumn = getColumn(pages, sourceIndexes);

    if (currentColumn) {
      if (direction === 'left') {
        newPages = handleResizeLeft(props, state, source, sourceIndexes, column);
      } else {
        newPages = handleResizeRight(props, state, source, sourceIndexes, column + 1);
      }
    }

    return {
      pages: newPages
    };
  };

  exports["default"] = _default;
  //# sourceMappingURL=columnResizedHandler.es.js.map
});
//# sourceMappingURL=columnResizedHandler.es.js.map