/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.builder.internal.converter;

import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.DDMFormRuleCondition;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.AutoFillDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.CalculateDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.DefaultDDMFormRuleAction;
import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.JumpToPageDDMFormRuleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormRuleDeserializer.class})
public class DDMFormRuleDeserializer {
    @Reference
    private JSONFactory _jsonFactory;

    public List<DDMFormRule> deserialize(String rules) throws PortalException {
        JSONArray rulesJSONArray = this._jsonFactory.createJSONArray(rules);
        ArrayList<DDMFormRule> ddmFormRules = new ArrayList<DDMFormRule>(rulesJSONArray.length());
        for (int i = 0; i < rulesJSONArray.length(); ++i) {
            DDMFormRule ddmFormRule = this.deserializeDDMFormRule(rulesJSONArray.getJSONObject(i));
            ddmFormRules.add(ddmFormRule);
        }
        return ddmFormRules;
    }

    protected DDMFormRule deserializeDDMFormRule(JSONObject ruleJSONObject) {
        DDMFormRule ddmFormRule = new DDMFormRule();
        List<DDMFormRuleAction> actions = this.deserializeDDMFormRuleActions(ruleJSONObject.getJSONArray("actions"));
        ddmFormRule.setDDMFormRuleActions(actions);
        List<DDMFormRuleCondition> conditions = this.deserializeDDMFormRuleConditions(ruleJSONObject.getJSONArray("conditions"));
        ddmFormRule.setDDMFormRuleConditions(conditions);
        ddmFormRule.setLogicalOperator(ruleJSONObject.getString("logical-operator"));
        return ddmFormRule;
    }

    protected <T extends DDMFormRuleAction> DDMFormRuleAction deserializeDDMFormRuleAction(JSONObject actionJSONObject, Class<T> targetClass) {
        JSONDeserializer jsonDeserializer = this._jsonFactory.createJSONDeserializer();
        return (DDMFormRuleAction)jsonDeserializer.deserialize(actionJSONObject.toString(), targetClass);
    }

    protected List<DDMFormRuleAction> deserializeDDMFormRuleActions(JSONArray actionsJSONArray) {
        ArrayList<DDMFormRuleAction> ddmFormRuleActions = new ArrayList<DDMFormRuleAction>();
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            String action = actionJSONObject.getString("action");
            Class<? extends DDMFormRuleAction> clazz = this.getDDMFormRuleActionClass(action);
            DDMFormRuleAction ddmFormRuleAction = this.deserializeDDMFormRuleAction(actionJSONObject, clazz);
            ddmFormRuleActions.add(ddmFormRuleAction);
        }
        return ddmFormRuleActions;
    }

    protected List<DDMFormRuleCondition> deserializeDDMFormRuleConditions(JSONArray conditionsJSONArray) {
        JSONDeserializer jsonDeserializer = this._jsonFactory.createJSONDeserializer();
        Object[] ruleConditions = (DDMFormRuleCondition[])jsonDeserializer.deserialize(conditionsJSONArray.toString(), DDMFormRuleCondition[].class);
        return ListUtil.fromArray((Object[])ruleConditions);
    }

    protected Class<? extends DDMFormRuleAction> getDDMFormRuleActionClass(String action) {
        if (action.equals("auto-fill")) {
            return AutoFillDDMFormRuleAction.class;
        }
        if (action.equals("calculate")) {
            return CalculateDDMFormRuleAction.class;
        }
        if (action.equals("jump-to-page")) {
            return JumpToPageDDMFormRuleAction.class;
        }
        return DefaultDDMFormRuleAction.class;
    }
}

