/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.mapping.form.builder.internal.converter.serializer;

import com.liferay.dynamic.data.mapping.form.builder.internal.converter.model.action.AutoFillDDMFormRuleAction;
import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.Map;
import java.util.Objects;

/**
 * @author Leonardo Barros
 */
public class AutoFillDDMFormRuleActionSerializer
	implements DDMFormRuleActionSerializer {

	public AutoFillDDMFormRuleActionSerializer(
		AutoFillDDMFormRuleAction autoFillDDMFormRuleAction) {

		_autoFillDDMFormRuleAction = autoFillDDMFormRuleAction;
	}

	@Override
	public String serialize(
		DDMFormRuleSerializerContext ddmFormRuleSerializerContext) {

		Map<String, String> inputParametersMapper =
			_autoFillDDMFormRuleAction.getInputParametersMapper();

		for (Map.Entry<String, String> inputParameterMapper :
				inputParametersMapper.entrySet()) {

			if (Objects.equals(
					inputParameterMapper.getValue(), StringPool.BLANK)) {

				return null;
			}
		}

		Map<String, String> outputParametersMapper =
			_autoFillDDMFormRuleAction.getOutputParametersMapper();

		for (Map.Entry<String, String> outputParameterMapper :
				outputParametersMapper.entrySet()) {

			if (Objects.equals(
					outputParameterMapper.getValue(), StringPool.BLANK)) {

				return null;
			}
		}

		return String.format(
			_FUNCTION_CALL_TERNARY_EXPRESSION_FORMAT, "call",
			StringUtil.quote(
				_autoFillDDMFormRuleAction.getDDMDataProviderInstanceUUID()),
			convertAutoFillInputParameters(inputParametersMapper),
			convertAutoFillOutputParameters(outputParametersMapper));
	}

	protected String convertAutoFillInputParameters(
		Map<String, String> inputParametersMapper) {

		if (MapUtil.isEmpty(inputParametersMapper)) {
			return StringUtil.quote(StringPool.BLANK);
		}

		StringBundler sb = new StringBundler(
			(inputParametersMapper.size() * 4) - 1);

		for (Map.Entry<String, String> inputParameterMapper :
				inputParametersMapper.entrySet()) {

			sb.append(inputParameterMapper.getKey());
			sb.append(CharPool.EQUAL);
			sb.append(inputParameterMapper.getValue());
			sb.append(CharPool.SEMICOLON);
		}

		sb.setIndex(sb.index() - 1);

		return StringUtil.quote(sb.toString());
	}

	protected String convertAutoFillOutputParameters(
		Map<String, String> outputParametersMapper) {

		if (MapUtil.isEmpty(outputParametersMapper)) {
			return StringUtil.quote(StringPool.BLANK);
		}

		StringBundler sb = new StringBundler(
			(outputParametersMapper.size() * 4) - 1);

		for (Map.Entry<String, String> outputParameterMapper :
				outputParametersMapper.entrySet()) {

			sb.append(outputParameterMapper.getValue());
			sb.append(CharPool.EQUAL);
			sb.append(outputParameterMapper.getKey());
			sb.append(CharPool.SEMICOLON);
		}

		sb.setIndex(sb.index() - 1);

		return StringUtil.quote(sb.toString());
	}

	private static final String _FUNCTION_CALL_TERNARY_EXPRESSION_FORMAT =
		"%s(%s, %s, %s)";

	private final AutoFillDDMFormRuleAction _autoFillDDMFormRuleAction;

}