Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.83/js/util/fieldSupport.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.localizeField = exports.getFieldProperties = exports.normalizeSettingsContextPages = exports.generateInstanceId = exports.formatFieldName = exports.createField = void 0;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var createField = function createField(props, event) {
    var defaultLanguageId = props.defaultLanguageId,
        editingLanguageId = props.editingLanguageId,
        fieldNameGenerator = props.fieldNameGenerator,
        spritemap = props.spritemap;
    var fieldType = event.fieldType,
        _event$skipFieldNameG = event.skipFieldNameGeneration,
        skipFieldNameGeneration = _event$skipFieldNameG === void 0 ? false : _event$skipFieldNameG;
    var newFieldName;

    if (skipFieldNameGeneration) {
      var _settingsContext = fieldType.settingsContext;
      var visitor = new _visitors.PagesVisitor(_settingsContext.pages);
      visitor.mapFields(function (_ref) {
        var fieldName = _ref.fieldName,
            value = _ref.value;

        if (fieldName === 'name') {
          newFieldName = value;
        }
      });
    } else {
      newFieldName = fieldNameGenerator(fieldType.label);
    }

    var newField = _objectSpread({}, fieldType, {
      fieldName: newFieldName,
      name: newFieldName,
      settingsContext: _objectSpread({}, fieldType.settingsContext, {
        pages: normalizeSettingsContextPages(fieldType.settingsContext.pages, editingLanguageId, fieldType, newFieldName),
        type: fieldType.name
      })
    });

    var fieldName = newField.fieldName,
        name = newField.name,
        settingsContext = newField.settingsContext;
    return _objectSpread({}, getFieldProperties(settingsContext, defaultLanguageId, editingLanguageId), {
      fieldName: fieldName,
      instanceId: generateInstanceId(8),
      name: name,
      settingsContext: settingsContext,
      spritemap: spritemap,
      type: fieldType.name
    });
  };

  exports.createField = createField;

  var formatFieldName = function formatFieldName(instanceId, languageId, value) {
    return "ddm$$".concat(value, "$").concat(instanceId, "$0$$").concat(languageId);
  };

  exports.formatFieldName = formatFieldName;

  var generateInstanceId = function generateInstanceId(length) {
    var text = '';
    var possible = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

    for (var i = 0; i < length; i++) {
      text += possible.charAt(Math.floor(Math.random() * possible.length));
    }

    return text;
  };

  exports.generateInstanceId = generateInstanceId;

  var normalizeSettingsContextPages = function normalizeSettingsContextPages(pages, editingLanguageId, fieldType, generatedFieldName) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapFields(function (field) {
      var _field = field,
          fieldName = _field.fieldName;

      if (fieldName === 'name') {
        field = _objectSpread({}, field, {
          value: generatedFieldName,
          visible: true
        });
      } else if (fieldName === 'label') {
        field = _objectSpread({}, field, {
          localizedValue: _objectSpread({}, field.localizedValue, _defineProperty({}, editingLanguageId, fieldType.label)),
          type: 'text',
          value: fieldType.label
        });
      } else if (fieldName === 'type') {
        field = _objectSpread({}, field, {
          value: fieldType.name
        });
      } else if (fieldName === 'validation') {
        field = _objectSpread({}, field, {
          validation: _objectSpread({}, field.validation, {
            fieldName: generatedFieldName
          })
        });
      }

      return _objectSpread({}, field);
    });
  };

  exports.normalizeSettingsContextPages = normalizeSettingsContextPages;

  var getFieldProperties = function getFieldProperties(_ref2, defaultLanguageId, editingLanguageId) {
    var pages = _ref2.pages;
    var properties = {};
    var visitor = new _visitors.PagesVisitor(pages);
    visitor.mapFields(function (_ref3) {
      var fieldName = _ref3.fieldName,
          localizable = _ref3.localizable,
          localizedValue = _ref3.localizedValue,
          type = _ref3.type,
          value = _ref3.value;

      if (localizable && (fieldName == 'predefinedValue' || localizedValue[editingLanguageId])) {
        properties[fieldName] = localizedValue[editingLanguageId];
      } else if (localizable && localizedValue[defaultLanguageId]) {
        properties[fieldName] = localizedValue[defaultLanguageId];
      } else if (type == 'options') {
        if (!value[editingLanguageId] && value[defaultLanguageId]) {
          properties[fieldName] = value[defaultLanguageId];
        } else {
          properties[fieldName] = value[editingLanguageId];
        }
      } else if (type == 'validation') {
        if (!value.errorMessage[editingLanguageId]) {
          value.errorMessage[editingLanguageId] = value.errorMessage[defaultLanguageId];
        }

        if (!value.parameter[editingLanguageId]) {
          value.parameter[editingLanguageId] = value.parameter[defaultLanguageId];
        }

        properties[fieldName] = value;
      } else {
        properties[fieldName] = value;
      }
    });
    return properties;
  };

  exports.getFieldProperties = getFieldProperties;

  var localizeField = function localizeField(field, defaultLanguageId, editingLanguageId) {
    var value = field.value;

    if (field.dataType === 'json' && _typeof(value) === 'object') {
      value = JSON.stringify(value);
    }

    if (field.localizable && field.localizedValue) {
      var localizedValue = field.localizedValue[editingLanguageId];

      if (localizedValue === undefined) {
        localizedValue = field.localizedValue[defaultLanguageId];
      }

      if (localizedValue !== undefined) {
        value = localizedValue;
      }
    } else if (field.dataType === 'ddm-options' && value[editingLanguageId] === undefined) {
      value = _objectSpread({}, value, _defineProperty({}, editingLanguageId, value[defaultLanguageId]));
    }

    return _objectSpread({}, field, {
      defaultLanguageId: defaultLanguageId,
      editingLanguageId: editingLanguageId,
      localizedValue: _objectSpread({}, field.localizedValue || {}, _defineProperty({}, editingLanguageId, value)),
      value: value
    });
  };

  exports.localizeField = localizeField;
  //# sourceMappingURL=fieldSupport.es.js.map
});
//# sourceMappingURL=fieldSupport.es.js.map