Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.83/js/components/LayoutProvider/handlers/fieldDuplicatedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../../../util/strings.es', '../util/fields.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.duplicateField = exports.getValidation = exports.getLabel = exports.createDuplicatedField = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _strings = require("../../../util/strings.es");

  var _fields = require("../util/fields.es");

  var _settingsContext = require("../util/settingsContext.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var createDuplicatedField = function createDuplicatedField(originalField, props) {
    var editingLanguageId = props.editingLanguageId,
        fieldNameGenerator = props.fieldNameGenerator;
    var label = getLabel(originalField, editingLanguageId);
    var newFieldName = fieldNameGenerator(label);
    var oldFieldName = originalField.fieldName;
    var duplicatedField = (0, _settingsContext.updateField)(props, originalField, 'name', newFieldName);
    duplicatedField = (0, _settingsContext.updateField)(props, duplicatedField, 'label', label);
    return (0, _settingsContext.updateField)(props, duplicatedField, 'validation', getValidation(duplicatedField, oldFieldName, newFieldName));
  };

  exports.createDuplicatedField = createDuplicatedField;

  var getLabel = function getLabel(originalField, editingLanguageId) {
    return (0, _strings.sub)(Liferay.Language.get('copy-of-x'), [(0, _fields.getFieldLocalizedValue)(originalField.settingsContext.pages, 'label', editingLanguageId)]);
  };

  exports.getLabel = getLabel;

  var getValidation = function getValidation(originalField, oldFieldName, newFieldName) {
    var validation = (0, _settingsContext.getSettingsContextProperty)(originalField.settingsContext, 'validation');
    var expression = validation.expression;

    if (expression && expression.value) {
      return _objectSpread({}, validation, {
        expression: _objectSpread({}, validation.expression, {
          value: expression.value.replace(oldFieldName, newFieldName)
        })
      });
    }

    return validation;
  };

  exports.getValidation = getValidation;

  var duplicateField = function duplicateField(props, pages, originalField, duplicatedField) {
    var visitor = new _visitors.PagesVisitor(pages);
    var parentField = FormSupport.getParentField(pages, originalField.fieldName);

    if (parentField) {
      return visitor.mapFields(function (field) {
        if (field.fieldName === parentField.fieldName) {
          var nestedFields = field.nestedFields ? [].concat(_toConsumableArray(field.nestedFields), [duplicatedField]) : [duplicatedField];
          field = (0, _settingsContext.updateField)(props, field, 'nestedFields', nestedFields);
          var _pages = [{
            rows: field.rows
          }];

          var _FormSupport$getField = FormSupport.getFieldIndexes(_pages, originalField.fieldName),
              _rowIndex = _FormSupport$getField.rowIndex;

          var _newRow = FormSupport.implAddRow(12, [duplicatedField.fieldName]);

          _pages = FormSupport.addRow(_pages, _rowIndex + 1, 0, _newRow);
          return (0, _settingsContext.updateField)(props, field, 'rows', _pages[0].rows);
        }

        return field;
      }, true, true);
    }

    var _FormSupport$getField2 = FormSupport.getFieldIndexes(pages, originalField.fieldName),
        rowIndex = _FormSupport$getField2.rowIndex;

    var newRow = FormSupport.implAddRow(12, [duplicatedField]);
    return FormSupport.addRow(pages, rowIndex + 1, 0, newRow);
  };

  exports.duplicateField = duplicateField;

  var handleFieldDuplicated = function handleFieldDuplicated(props, state, event) {
    var fieldName = event.fieldName;
    var pages = state.pages;
    var originalField = FormSupport.findFieldByName(pages, fieldName);
    var duplicatedField = createDuplicatedField(originalField, props);
    return {
      focusedField: _objectSpread({}, duplicatedField),
      pages: duplicateField(props, pages, originalField, duplicatedField)
    };
  };

  var _default = handleFieldDuplicated;
  exports["default"] = _default;
  //# sourceMappingURL=fieldDuplicatedHandler.es.js.map
});
//# sourceMappingURL=fieldDuplicatedHandler.es.js.map