Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.83/js/components/Calculator/Calculator.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-dropdown', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', '../../expressions/Token.es', '../../expressions/Tokenizer.es', './Calculator.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  require("frontend-taglib-clay$clay-dropdown");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _Token = _interopRequireDefault(require("../../expressions/Token.es"));

  var _Tokenizer = _interopRequireDefault(require("../../expressions/Tokenizer.es"));

  var _Calculator = _interopRequireDefault(require("./Calculator.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Calculator.
   * @extends Component
   */
  var Calculator = /*#__PURE__*/function (_Component) {
    _inherits(Calculator, _Component);

    function Calculator() {
      _classCallCheck(this, Calculator);

      return _possibleConstructorReturn(this, _getPrototypeOf(Calculator).apply(this, arguments));
    }

    _createClass(Calculator, [{
      key: "addTokenToExpression",
      value: function addTokenToExpression(tokenType, tokenValue) {
        var expression = this.expression,
            index = this.index;
        var newToken = new _Token["default"](tokenType, tokenValue);

        var tokens = _Tokenizer["default"].tokenize(expression);

        if (this.shouldAddImplicitMultiplication(tokens, newToken)) {
          tokens.push(new _Token["default"](_Token["default"].OPERATOR, '*'));
        }

        tokens.push(newToken);
        this.setState({
          expression: _Tokenizer["default"].stringifyTokens(tokens)
        });
        this.emit('editExpression', {
          expression: this.expression,
          index: index
        });
      }
    }, {
      key: "getStateBasedOnExpression",
      value: function getStateBasedOnExpression(expression) {
        var disableDot = false;
        var disableFunctions = false;
        var disableNumbers = false;
        var disableOperators = false;
        var showOnlyRepeatableFields = false;

        var tokens = _Tokenizer["default"].tokenize(expression);

        if (tokens.length > 1 && tokens[tokens.length - 1].type === _Token["default"].LEFT_PARENTHESIS && tokens[tokens.length - 2].type === _Token["default"].FUNCTION && tokens[tokens.length - 2].value === 'sum') {
          disableFunctions = true;
          disableNumbers = true;
          disableOperators = true;
          showOnlyRepeatableFields = true;
        }

        if (tokens.length === 0 || tokens.length > 0 && tokens[tokens.length - 1].type !== _Token["default"].LITERAL) {
          disableDot = true;
        }

        if (tokens.length > 0 && tokens[tokens.length - 1].type === _Token["default"].OPERATOR) {
          disableOperators = true;
        }

        return {
          disableDot: disableDot,
          disableFunctions: disableFunctions,
          disableNumbers: disableNumbers,
          disableOperators: disableOperators,
          showOnlyRepeatableFields: showOnlyRepeatableFields
        };
      }
    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        var expression = state.expression;
        return _objectSpread({}, state, {}, this.getStateBasedOnExpression(expression), {
          expression: expression.replace(/[[\]]/g, '')
        });
      }
    }, {
      key: "removeTokenFromExpression",
      value: function removeTokenFromExpression() {
        var expression = this.expression,
            index = this.index;

        var tokens = _Tokenizer["default"].tokenize(expression);

        var removedToken = tokens.pop();

        if (removedToken && removedToken.type === _Token["default"].LEFT_PARENTHESIS && tokens.length && tokens[tokens.length - 1].type === _Token["default"].FUNCTION) {
          tokens.pop();
        }

        this.setState({
          expression: _Tokenizer["default"].stringifyTokens(tokens)
        });
        this.emit('editExpression', {
          expression: this.expression,
          index: index
        });
      }
    }, {
      key: "shouldAddImplicitMultiplication",
      value: function shouldAddImplicitMultiplication(tokens, newToken) {
        var lastToken = tokens[tokens.length - 1];
        return lastToken !== undefined && (newToken.type === _Token["default"].LEFT_PARENTHESIS && lastToken.type !== _Token["default"].OPERATOR && lastToken.type !== _Token["default"].FUNCTION && lastToken.type !== _Token["default"].LEFT_PARENTHESIS || newToken.type === _Token["default"].FUNCTION && lastToken.type !== _Token["default"].OPERATOR && lastToken.type !== _Token["default"].LEFT_PARENTHESIS || newToken.type === _Token["default"].VARIABLE && (lastToken.type === _Token["default"].VARIABLE || lastToken.type === _Token["default"].LITERAL) || newToken.type === _Token["default"].LITERAL && (lastToken.type === _Token["default"].VARIABLE || lastToken.type === _Token["default"].FUNCTION));
      }
    }, {
      key: "_handleButtonClicked",
      value: function _handleButtonClicked(_ref) {
        var delegateTarget = _ref.delegateTarget;
        var _delegateTarget$datas = delegateTarget.dataset,
            tokenType = _delegateTarget$datas.tokenType,
            tokenValue = _delegateTarget$datas.tokenValue;

        if (tokenValue === 'backspace') {
          this.removeTokenFromExpression();
        } else {
          this.addTokenToExpression(tokenType, tokenValue);
        }
      }
    }, {
      key: "_handleFieldsDropdownItemClicked",
      value: function _handleFieldsDropdownItemClicked(_ref2) {
        var data = _ref2.data;
        var item = data.item;
        var fieldName = item.fieldName;
        this.addTokenToExpression(_Token["default"].VARIABLE, fieldName);
      }
    }, {
      key: "_handleFunctionsDropdownItemClicked",
      value: function _handleFunctionsDropdownItemClicked(_ref3) {
        var data = _ref3.data;
        var item = data.item;
        this.addTokenToExpression(_Token["default"].FUNCTION, item.value);
        this.addTokenToExpression(_Token["default"].LEFT_PARENTHESIS, '(');
      }
    }, {
      key: "_repeatableFieldsValueFn",
      value: function _repeatableFieldsValueFn() {
        var fields = this.fields;
        return fields.filter(function (_ref4) {
          var repeatable = _ref4.repeatable;
          return repeatable === true;
        });
      }
    }]);

    return Calculator;
  }(_metalComponent["default"]);

  Calculator.STATE = {
    expression: _metalState.Config.string().value(''),
    fields: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      fieldName: _metalState.Config.string(),
      label: _metalState.Config.string(),
      repeatable: _metalState.Config.bool(),
      value: _metalState.Config.string()
    })).value([]),
    functions: _metalState.Config.array().value([]),
    index: _metalState.Config.number().value(0),
    repeatableFields: _metalState.Config.array().valueFn('_repeatableFieldsValueFn'),
    spritemap: _metalState.Config.string().required()
  };

  _metalSoy["default"].register(Calculator, _Calculator["default"]);

  var _default = Calculator;
  exports["default"] = _default;
  //# sourceMappingURL=Calculator.es.js.map
});
//# sourceMappingURL=Calculator.es.js.map